<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin;

use Admin\Controller\AdminController;
use Admin\Controller\AdminGroupController;
use Admin\Controller\CurrencyController;
use Admin\Controller\CustomerSetController;
use Admin\Controller\DeliveryController;
use Admin\Controller\DeliverySetController;
use Admin\Controller\MessageNotificationController;
use Admin\Controller\OperLogController;
use Admin\Controller\PaymentController;
use Admin\Controller\PhoneAreaCodeController;
use Admin\Controller\RegionController;
use Admin\Controller\SelfLocationController;
use Admin\Controller\ServiceBindController;
use Admin\Controller\SystemController;
use Admin\Controller\TemplateController;
use Admin\Controller\UpdateController;
use Admin\Controller\UploadSetController;

return [
    'Admin' => [
        'name' => '系统',
        'controllers' => [
            SystemController::class => [
                'name' => '系统设置',
                'action' => ['index'],
                'actionNames' => [
                    'index'         => '系统设置'
                ]
            ],
            AdminController::class => [
                'name' => '管理员',
                'action' => ['index', 'add', 'edit', 'delete', 'changePassword'],
                'actionNames' => [
                    'index' => '管理员列表',
                    'add'   => '管理员添加',
                    'edit'  => '管理员编辑',
                    'delete'=> '管理员删除',
                    'changePassword' => '修改密码'
                ]
            ],
            AdminGroupController::class => [
                'name' => '管理员组',
                'action' => ['adminGroupList', 'addAdminGroup', 'editAdminGroup', 'deleteAdminGroup'],
                'actionNames' => [
                    'adminGroupList'    => '管理员组列表',
                    'addAdminGroup'     => '添加管理员组',
                    'editAdminGroup'    => '编辑管理员组',
                    'deleteAdminGroup'  => '删除管理员组'
                ]
            ],
            CustomerSetController::class => [
                'name' => '客户设置',
                'action' => ['index'],
                'actionNames' => [
                    'index'         => '客户设置'
                ]
            ],
            RegionController::class => [
                'name' => '地区管理',
                'action' => ['index', 'add', 'edit', 'delete'],
                'actionNames' => [
                    'index' => '地区列表',
                    'add'   => '添加地区',
                    'edit'  => '编辑地区',
                    'delete'=> '删除地区'
                ]
            ],
            PaymentController::class => [
                'name' => '支付设置',
                'action' => ['index', 'edit'],
                'actionNames' => [
                    'index' => '支付列表',
                    'edit'  => '编辑支付'
                ]
            ],
            CurrencyController::class => [
                'name' => '货币设置',
                'action' => ['index', 'add', 'edit', 'delete'],
                'actionNames' => [
                    'index' => '货币列表',
                    'add'   => '添加货币',
                    'edit'  => '编辑货币',
                    'delete'=> '删除货币'
                ]
            ],
            PhoneAreaCodeController::class => [
                'name' => '国际电话区号',
                'action' => ['index', 'add', 'edit', 'delete'],
                'actionNames' => [
                    'index' => '国际电话区号列表',
                    'add'   => '添加国际电话区号',
                    'edit'  => '编辑国际电话区号',
                    'delete'=> '删除国际电话区号'
                ]
            ],
            UploadSetController::class => [
                'name' => '图片附件',
                'action' => ['index'],
                'actionNames' => [
                    'index'         => '图片附件设置'
                ]
            ],
            MessageNotificationController::class => [
                'name' => '消息提醒',
                'action' => ['index', 'emailMessageNotification'],
                'actionNames' => [
                    'index' => '手机短信提醒',
                    'emailMessageNotification' => '电子邮件提醒'
                ]
            ],
            DeliverySetController::class => [
                'name' => '商家配送设置',
                'action' => [
                    'index', 'addSingleArea', 'infoSingleArea', 'delSingleArea', 'checkDeliveryPrice'
                ],
                'actionNames' => [
                    'index' => '商家配送',
                    'addSingleArea' => '添加个性地区设置',
                    'infoSingleArea'=> '获取个性地区设置',
                    'delSingleArea' => '删除个性地区设置',
                    'checkDeliveryPrice' => '验证公式'
                ]
            ],
            DeliveryController::class => [
                'name' => '配送管理',
                'action' => [
                    'index', 'add', 'edit', 'delete'
                ],
                'actionNames' => [
                    'index' => '配送列表',
                    'add'   => '添加配送',
                    'edit'  => '编辑配送',
                    'delete'=> '删除配送'
                ]
            ],
            SelfLocationController::class => [
                'name' => '自提点设置',
                'action' => [
                    'index', 'add', 'edit', 'delete'
                ],
                'actionNames' => [
                    'index' => '自提点列表',
                    'add'   => '添加自提点',
                    'edit'  => '编辑自提点',
                    'delete'=> '删除自提点'
                ]
            ],
            ServiceBindController::class => [
                'name' => '服务绑定',
                'action' => ['index', 'clearServiceBind'],
                'actionNames' => [
                    'index' => '服务绑定',
                    'clearServiceBind' => '服务解绑'
                ]
            ],
            TemplateController::class => [
                'name' => '模板管理',
                'action' => ['index', 'mobileTemplate', 'installPcTemplate', 'installMobileTemplate'],
                'actionNames' => [
                    'index' => '电脑端模板',
                    'mobileTemplate'    => '手机端模板',
                    'installPcTemplate' => '在线安装电脑端模板',
                    'installMobileTemplate' => '在线安装手机端模板'
                ]
            ],
            UpdateController::class => [
                'name' => '系统更新',
                'action' => ['index', 'updatePackageInfo', 'startShopPackage'],
                'actionNames' => [
                    'index' => '更新包列表',
                    'updatePackageInfo' => '查看更新包详情',
                    'startShopPackage'  => '更新包更新'
                ]
            ],
            OperLogController::class => [
                'name' => '操作日志',
                'action' => ['index', 'clearOperLog'],
                'actionNames' => [
                    'index'         => '查看日志',
                    'clearOperLog'  => '删除日志'
                ]
            ],

        ]
    ]
];