<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Controller;

use Admin\Data\Common;
use Admin\Data\Config;
use Admin\Entity\System;
use Admin\Form\CustomerSetForm;
use Admin\Service\SystemManager;
use Doctrine\ORM\EntityManager;
use Laminas\Mvc\I18n\Translator;

class CustomerSetController extends AdminActionController
{
    private $translator;
    private $entityManager;
    private $systemManager;

    public function __construct(
        Translator $translator,
        EntityManager $entityManager,
        SystemManager $systemManager
    )
    {
        $this->translator   = $translator;
        $this->entityManager= $entityManager;
        $this->systemManager= $systemManager;
    }

    /**
     * 客户设置
     * @return array|\Laminas\Http\Response|\Laminas\View\Model\ViewModel
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function indexAction()
    {
        $form = new CustomerSetForm();
        $form->get('register_status')->setValueOptions(Common::state($this->translator));
        $form->get('default_user_group_id')->setValueOptions($this->userPlugin()->userGroupOptions('', true, true));
        $form->get('user_register_audit')->setValueOptions(Common::userAuditType($this->translator));
        $form->get('login_item')->setValueOptions(['email' => $this->translator->translate('电子邮箱'), 'phone' => $this->translator->translate('手机号码')]);
        //$form->get('user_login_password_edit')->setValueOptions(Common::verificationArray($this->translator, ['email', 'phone']));
        //$form->get('user_pay_password_edit')->setValueOptions(Common::verificationArray($this->translator, ['email', 'phone']));
        //$form->get('user_email_edit')->setValueOptions(Common::verificationArray($this->translator, ['email']));
        //$form->get('user_phone_edit')->setValueOptions(Common::verificationArray($this->translator, ['phone']));

        if($this->getRequest()->isPost()) {
            $data = array_merge_recursive(
                $this->getRequest()->getPost()->toArray(),
                $this->getRequest()->getFiles()->toArray()
            );
            $form->setData($data);
            if ($form->isValid()) {
                $data = $form->getData();
                foreach ($data as $dataKey => $dataValue) {
                    if($dataKey == 'default_user_avatar') {
                        $dataValue = str_replace(Config::PUBLIC_PATH, '', $dataValue['tmp_name']);
                        if(empty($dataValue)) continue;
                    }

                    if ($dataKey == 'login_item' && !empty($dataValue)) $dataValue = serialize($dataValue);

                    $oneSystem = $this->entityManager->getRepository(System::class)->findOneBy(['sysName' => $dataKey, 'sysType' => 'customer']);
                    if($oneSystem) {
                        if($oneSystem->getSysBody() != $dataValue) $this->systemManager->editSystem($oneSystem, $dataValue);
                    } else {
                        $this->systemManager->addSystem(['sysName' => $dataKey, 'sysBody' => $dataValue, 'sysType' => 'customer']);
                    }
                }

                $this->createConfig()->createCustomer();

                $this->adminCommon()->addOperLog($this->translator->translate('客户设置 修改成功!'), $this->translator->translate('系统设置'));

                return $this->redirect()->toRoute('customer-set');
            }
        }

        $system = $this->entityManager->getRepository(System::class)->findBy(['sysType' => 'customer']);
        $systemArray = [];
        if($system) {
            foreach ($system as $value) {
                $systemArray[$value->getSysName()] = $value->getSysName() == 'login_item' ? unserialize($value->getSysBody()) : $value->getSysBody();
            }
            $form->setData($systemArray);
        }

        return [
            'form' => $form,
            'welcomeEmailBody'  => $systemArray['welcome_email_body'],
            'registerAgreement' => $systemArray['register_agreement']
        ];
    }
}