<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Controller;

use Admin\Data\Common;
use Admin\Entity\Plugin;
use Admin\Entity\Template;
use Carbon\Carbon;
use Doctrine\ORM\EntityManager;
use Laminas\Config\Reader\Ini;
use Laminas\Mvc\I18n\Translator;
use Sales\Entity\Order;
use Sales\Entity\OrderGoodsReturn;
use User\Entity\User;

class HomeController extends AdminActionController
{
    private $translator;
    private $entityManager;
    private $i18nSessionContainer;

    public function __construct(
        Translator      $translator,
        EntityManager   $entityManager,
        $i18nSessionContainer
    )
    {
        $this->translator           = $translator;
        $this->entityManager        = $entityManager;
        $this->i18nSessionContainer = $i18nSessionContainer;
    }

    /**
     * 后台首页
     * @return array
     */
    public function indexAction()
    {
        $todayStart = Carbon::today()->timestamp;
        $todayEnd   = Carbon::now()->timestamp;

        $todayOrderNum      = $this->entityManager->getRepository(Order::class)->findOrderCount($todayStart, $todayEnd);
        $todayOrderAmount   = $this->entityManager->getRepository(Order::class)->findOrderTotal($todayStart, $todayEnd);
        $todayUserNum       = $this->entityManager->getRepository(User::class)->findUserCount($todayStart, $todayEnd);
        $todayReturnNum     = $this->entityManager->getRepository(OrderGoodsReturn::class)->findOrderReturnCount($todayStart, $todayEnd);

        $serviceBind = Common::readConfigFile('dbshopService');

        $data['pcTemplate'] = $this->templateCodeArray();
        $data['mobileTemplate'] = $this->templateCodeArray('mobile');
        $data['plugin']     = $this->pluginCodeArray();
        $result = $this->adminCommon()->dbshopApiService('empty', $data, '/latestNews');

        return [
            'todayOrderNum'     => $todayOrderNum,
            'todayOrderAmount'  => $todayOrderAmount,
            'todayUserNum'      => $todayUserNum,
            'todayReturnNum'    => $todayReturnNum,

            'serviceBind'=> $serviceBind,

            'newsList'      => $result['result']['newsList']??null,
            'newPackage'    => $result['result']['newPackage']??0,
            'pcTemplate'    => $result['result']['pcTemplate']??0,
            'mobileTemplate'=> $result['result']['mobileTemplate']??0,
            'pluginPackage' => $result['result']['pluginPackage']??0,
            'dbshopAuth'    => $result['result']['dbshopAuth']??0,
        ];
    }

    public function notAuthorizedAction()
    {
        return [];
    }

    /**
     * 获取模板编码
     * @param string $type
     * @return array|string
     */
    private function templateCodeArray($type = 'pc')
    {
        if (!in_array($type, ['pc', 'mobile'])) return '';

        $templateList       = $this->entityManager->getRepository(Template::class)->findBy(['templateType' => $type]);
        $templateCodeArray  = [];
        if ($templateList) foreach ($templateList as $templateValue) {
            $templateCodeArray['t'][] = $templateValue->getTemplateCode();
            $templateCodeArray['n'][$templateValue->getTemplateCode()] = $templateValue->getTemplateVersionNumber();
        }
        if (
            $type == 'pc'
            && (
                !isset($templateCodeArray['t'])
                || (isset($templateCodeArray['t']) && !in_array('pc-default', $templateCodeArray['t']) && file_exists('module/Shop/view/pc/default/shop/template.ini'))
            )
        ) {
            $iniReader = new Ini();

            $templateCodeArray['t'][] = 'pc-default';
            $templateCodeArray['n']['pc-default'] = $iniReader->fromFile('module/Shop/view/pc/default/shop/template.ini')['templateInfo']['versionNumber'];
        }

        return $templateCodeArray;
    }

    /**
     * 获取插件编码
     * @return array
     */
    private function pluginCodeArray()
    {
        $codeArray = [];
        $pluginList= $this->entityManager->getRepository(Plugin::class)->findBy([]);
        if ($pluginList) foreach ($pluginList as $plugin) {
            $codeArray['pluginCode'][] = $plugin->getPluginCode();
            $codeArray['versionNumber'][$plugin->getPluginCode()] = $plugin->getPluginVersionNum();
        }

        return $codeArray;
    }
}