<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Controller;

use Admin\Data\Common;
use Admin\Form\EmailMessageForm;
use Admin\Form\PhoneSmsForm;
use Doctrine\ORM\EntityManager;
use Laminas\Mvc\I18n\Translator;

class MessageNotificationController extends AdminActionController
{
    private $translator;
    private $entityManager;

    public function __construct(
        Translator      $translator,
        EntityManager   $entityManager
    )
    {
        $this->translator       = $translator;
        $this->entityManager    = $entityManager;
    }

    /**
     * 手机短信提醒设置
     * @return array|\Laminas\Http\Response|\Laminas\View\Model\ViewModel
     */
    public function indexAction()
    {
        $smsConfig  = Common::configValue('sms', 'config');
        $phoneArea  = Common::getPhoneArea();
        $form = new PhoneSmsForm($phoneArea);
        $form->get('adminPhoneSend')->setValueOptions(Common::adminReceivePhoneMessage($this->translator));

        if($this->getRequest()->isPost()) {
            $data = $this->params()->fromPost();
            $form->setData($data);
            if ($form->isValid()) {
                $data = $form->getData();

                $smsData = [
                    'areaCode'          => $data['areaCode'],
                    'adminPhone'        => $data['adminPhone'],
                    'adminPhoneSend'    => $data['adminPhoneSend']
                ];
                unset($data['areaCode'], $data['adminPhone'], $data['adminPhoneSend']);
                $smsData[$smsConfig['sms_service_provider']] = $data;

                Common::writeConfigFile('phoneMessage', $smsData);

                $this->adminCommon()->addOperLog($this->translator->translate('手机短信提醒设置成功!'), $this->translator->translate('消息提醒'));
                return $this->redirect()->toRoute('message-notification');
            }
        }

        $smsData = Common::readConfigFile('phoneMessage');
        $form->setData(['areaCode' => $smsData['areaCode'], 'adminPhone' => $smsData['adminPhone'], 'adminPhoneSend' => $smsData['adminPhoneSend']]);
        if(isset($smsData[$smsConfig['sms_service_provider']])) $form->setData($smsData[$smsConfig['sms_service_provider']]);

        return ['form' => $form, 'phoneArea' => $phoneArea, 'smsConfig' => $smsConfig];
    }

    /**
     * 电子邮件提醒设置
     * @return EmailMessageForm[]|\Laminas\Http\Response
     */
    public function emailMessageNotificationAction()
    {
        $form = new EmailMessageForm();

        if($this->getRequest()->isPost()) {
            $data = $this->params()->fromPost();
            $form->setData($data);
            if ($form->isValid()) {
                $data = $form->getData();
                Common::writeConfigFile('emailMessage', $data);

                $this->adminCommon()->addOperLog($this->translator->translate('电子邮件提醒设置成功!'), $this->translator->translate('消息提醒'));
                return $this->redirect()->toRoute('message-notification', ['action' => 'emailMessageNotification']);
            }
        }
        $form->setData(Common::readConfigFile('emailMessage'));

        return ['form' => $form];
    }
}