<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Controller;

use Admin\Data\Common;
use Admin\Form\ServiceBindForm;
use Doctrine\ORM\EntityManager;
use Laminas\Mvc\I18n\Translator;
use Laminas\View\Model\ViewModel;

class ServiceBindController extends AdminActionController
{
    private $translator;
    private $entityManager;

    public function __construct(
        Translator      $translator,
        EntityManager   $entityManager
    )
    {
        $this->translator   = $translator;
        $this->entityManager= $entityManager;
    }

    /**
     * 服务绑定
     * @return ServiceBindForm[]|\Laminas\Http\Response|ViewModel
     */
    public function indexAction()
    {
        $form = new ServiceBindForm();
        if($this->getRequest()->isPost()) {
            $data = $this->params()->fromPost();
            $form->setData($data);
            if ($form->isValid()) {
                $this->adminCommon()->addOperLog($this->translator->translate('服务绑定成功!'), $this->translator->translate('服务绑定'));
                return $this->redirect()->toRoute('service-bind');
            }
        }

        $serviceBind = Common::readConfigFile('dbshopService');
        if (
            isset($serviceBind['userName']) && !empty($serviceBind['userName'])
            && isset($serviceBind['key']) && !empty($serviceBind['key'])
            && isset($serviceBind['code']) && !empty($serviceBind['code'])
        ) {
           $viewMode = new ViewModel();
           $viewMode->setTemplate('admin/service-bind/finish.phtml');

           return $viewMode->setVariables($serviceBind);
        }

        return ['form' => $form];
    }

    /**
     * 服务解绑
     * @return \Laminas\Http\Response
     */
    public function clearServiceBindAction()
    {
        Common::writeConfigFile('dbshopService', ['userName' => '', 'key' => '', 'code' => '']);
        $this->adminCommon()->addOperLog($this->translator->translate('服务解绑成功!'), $this->translator->translate('服务绑定'));
        return $this->redirect()->toRoute('service-bind');
    }
}