<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Controller;

use Admin\Data\Common;
use Admin\Data\Config;
use Admin\Entity\System;
use Admin\Form\UploadSetForm;
use Admin\Service\SystemManager;
use Doctrine\ORM\EntityManager;
use Laminas\Mvc\I18n\Translator;

class UploadSetController extends AdminActionController
{
    private $translator;
    private $entityManager;
    private $systemManager;

    public function __construct(
        Translator $translator,
        EntityManager $entityManager,
        SystemManager $systemManager
    )
    {
        $this->translator       = $translator;
        $this->entityManager    = $entityManager;
        $this->systemManager    = $systemManager;
    }

    /**
     * 图片附件设置
     * @return array|\Laminas\Http\Response|\Laminas\View\Model\ViewModel
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function indexAction()
    {
        $form = new UploadSetForm();
        $form->get('image_type')->setValueOptions(Common::imageType());
        $form->get('goods_image_crop')->setValueOptions(Common::imageCrop($this->translator));
        $form->get('goods_image_name_type')->setValueOptions(Common::imageRenameType($this->translator));
        $form->get('brand_logo_crop')->setValueOptions(Common::imageCrop($this->translator));
        $form->get('class_image_crop')->setValueOptions(Common::imageCrop($this->translator));

        $form->get('watermark_state')->setValueOptions(Common::state($this->translator));
        $form->get('watermark_type')->setValueOptions(Common::watermarkType($this->translator));
        $form->get('watermark_location')->setValueOptions(Common::watermarkLocation($this->translator));

        $form->get('storage_type')->setValueOptions(Common::storageType($this->translator));
        $form->get('qiniu_scheme')->setValueOptions(Common::urlScheme());
        $form->get('aliyun_oss_domain')->setValueOptions(Common::aliyunOssDomain($this->translator));
        $form->get('aliyun_scheme')->setValueOptions(Common::urlScheme());
        $form->get('aliyun_domain_type')->setValueOptions(Common::aliyunDomainType($this->translator));

        if($this->getRequest()->isPost()) {
            $data = array_merge_recursive(
                $this->getRequest()->getPost()->toArray(),
                $this->getRequest()->getFiles()->toArray()
            );
            $form->setData($data);
            if($form->isValid()) {
                $data = $form->getData();
                foreach ($data as $dataKey => $dataValue) {
                    if(in_array($dataKey, ['watermark_image', 'goods_image_default', 'brand_logo_default', 'class_image_default'])) {
                        $dataValue = str_replace(Config::PUBLIC_PATH, '', $dataValue['tmp_name']);
                        if(empty($dataValue)) continue;
                    }
                    if($dataKey == 'image_type') $dataValue = implode('|', $dataValue);

                    $oneSystem = $this->entityManager->getRepository(System::class)->findOneBy(['sysName' => $dataKey, 'sysType' => 'upload']);
                    if($oneSystem) {
                        if($oneSystem && $oneSystem->getSysBody() != $dataValue) $this->systemManager->editSystem($oneSystem, $dataValue);
                    } else {
                        $this->systemManager->addSystem(['sysName' => $dataKey, 'sysBody' => $dataValue, 'sysType' => 'upload']);
                    }
                }

                $this->createConfig()->createUpload();

                $this->adminCommon()->addOperLog($this->translator->translate('图片附件 修改成功!'), $this->translator->translate('系统设置'));

                return $this->redirect()->toRoute('upload-set');
            }
        }

        $system = $this->entityManager->getRepository(System::class)->findBy(['sysType' => 'upload']);
        $systemArray = [];
        if($system) {
            foreach ($system as $value) {
                if($value->getSysName() == 'image_type') $systemArray[$value->getSysName()] = explode('|', $value->getSysBody());
                else $systemArray[$value->getSysName()] = $value->getSysBody();
            }
            $form->setData($systemArray);
        }

        return ['form' => $form];
    }
}