<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Data;


class Config
{
    /**
     * 管理后台路径
     */
    const ADMIN_PATH = 'admin';

    /**
     * 管理登录是否需要验证码
     */
    const ADMIN_LOGIN_CAPTCHA = true;

    /**
     * 系统服务地址
     */
    const SERVICE_URL       = 'https://service.loongdom.cn/';

    /**
     * 系统服务api
     */
    const SERVICE_API_URL   = self::SERVICE_URL . 'service-api';

    /**
     * 插件图片路径
     */
    const PLUGIN_IMAGE_URL = self::SERVICE_URL . 'upload/plugin/image/';

    /**
     * 手机验证码间隔时间
     */
    const PHONE_CAPTCHA_EXPIRED_SECOND = 90;

    /**
     * 邮箱验证码间隔时间
     */
    const EMAIL_CAPTCHA_EXPIRED_SECOND = 120;

    /**
     * 后台提交表单的token失效时间(后台暂未使用标摊token)
     */
    const POST_TOKEN_TIMEOUT = 600;

    /**
     * 前台提交表单token失效时间
     */
    const SHOP_POST_TOKEN_TIMEOUT = 600;

    /**
     * 前台购物车每人可放入的最大商品数量（非购买数量）
     */
    const USER_CART_GOODS_MAX_NUM = 60;

    /**
     * 单次生成充值码的最大数量
     */
    const CREATE_RECHARGE_CODE_MAX_NUM = 500;

    /**
     * 数据库写
     */
    const SHOP_DATABASE_MANAGER_WRITE = 'doctrine.entitymanager.orm_default';

    /**
     * 数据库读
     */
    const SHOP_DATABASE_MANAGER_READ = 'doctrine.entitymanager.orm_read_default';

    /**
     * 时区，默认中国上海
     */
    const SHOP_TIME_ZONE = 'Asia/Shanghai';

    /**
     * 时间格式类型，默认 zh_CN 中国
     */
    const SHOP_DATE_FORMAT = 'zh_CN';

    /**
     * 货币地区，默认 zh_CN 中国
     */
    const SHOP_CURRENCY_LOCALE = 'zh_CN';

    /**
     * 货币标识，默认 CNY 人民币
     */
    const SHOP_CURRENCY_CODE = 'CNY';

    /**
     * 公共目录
     */
    const PUBLIC_PATH = 'public/';

    /**
     * 系统公共图片路径，如logo
     */
    const COMMON_IMAGE_PATH = self::PUBLIC_PATH . 'upload/common/';

    /**
     * 系统配置，内容设置里的图片路径
     */
    const SYSTEM_SERVICE_IMAGE_PATH = self::PUBLIC_PATH . 'upload/other/';

    /**
     * 商品分类图片路径
     */
    const GOODS_CLASS_IMAGE_PATH = self::PUBLIC_PATH . 'upload/goods/class/';

    /**
     * 商品图片路径
     */
    const GOODS_IMAGE_PATH  = self::PUBLIC_PATH . 'upload/goods/image/';

    /**
     * 商品通用内容图片路径
     */
    const GOODS_COMMON_IMAGE_PATH = self::PUBLIC_PATH . 'upload/goods/common/';

    /**
     * 商品品牌路径
     */
    const GOODS_BRAND_IMAGE_PATH = self::PUBLIC_PATH . 'upload/goods/brand/';

    /**
     * 商品分享海报图
     */
    const GOODS_QRCODE_IMAGE_PATH = self::PUBLIC_PATH . 'upload/goods/qrcode/';

    /**
     * 客户分享站点二维码
     */
    const USER_INVITATION_IMAGE_PATH = self::PUBLIC_PATH . 'upload/user/invitation/';

    /**
     * 订单商品图片
     */
    const ORDER_GOODS_IMAGE_PATH = self::PUBLIC_PATH . 'upload/order/image/';

    /**
     * 客户头像路径
     */
    const USER_AVATAR_IMAGE_PATH = self::PUBLIC_PATH . 'upload/user/avatar/';

    /**
     * 文章图片路径
     */
    const CMS_IMAGE_PATH = self::PUBLIC_PATH . 'upload/cms/image/';

    /**
     * 广告图片路径
     */
    const AD_IMAGE_PATH = self::PUBLIC_PATH . 'upload/adImage/';

    /**
     * 在线更新的KEY
     */
    const PACKAGE_UPDATE_KEY_FILE = 'data/moduleData/Package/updateKey.ini';
}