<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * 货币设置
 * Class Currency
 * @package Admin\Entity
 * @ORM\Entity(repositoryClass="Admin\Repository\CurrencyRepository")
 * @ORM\Table(name="dbshop_currency")
 */
class Currency extends BaseEntity
{
    /**
     * 货币id
     * @ORM\Id()
     * @ORM\Column(name="currency_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $currencyId;

    /**
     * 货币名称
     * @ORM\Column(name="currency_name", type="string", length=20)
     */
    private $currencyName;

    /**
     * 货币标记
     * @ORM\Column(name="currency_code", type="string", length=5)
     */
    private $currencyCode;

    /**
     * 货币符号
     * @ORM\Column(name="currency_symbol", type="string", length=5)
     */
    private $currencySymbol;

    /**
     * 货币小数点位数
     * @ORM\Column(name="currency_decimal", type="integer", length=1)
     */
    private $currencyDecimal;

    /**
     * 货币汇率
     * @ORM\Column(name="currency_rate", type="string", length=10)
     */
    private $currencyRate;

    /**
     * 货币类型，1 基础货币，0 非基础货币
     * @ORM\Column(name="currency_type", type="integer", length=1)
     */
    private $currencyType;

    /**
     * 货币状态，1 启用，0 禁用
     * @ORM\Column(name="currency_state", type="integer", length=1)
     */
    private $currencyState;

    /**
     * @return mixed
     */
    public function getCurrencyId()
    {
        return $this->currencyId;
    }

    /**
     * @param mixed $currencyId
     */
    public function setCurrencyId($currencyId): void
    {
        $this->currencyId = $currencyId;
    }

    /**
     * @return mixed
     */
    public function getCurrencyName()
    {
        return $this->currencyName;
    }

    /**
     * @param mixed $currencyName
     */
    public function setCurrencyName($currencyName): void
    {
        $this->currencyName = $currencyName;
    }

    /**
     * @return mixed
     */
    public function getCurrencyCode()
    {
        return $this->currencyCode;
    }

    /**
     * @param mixed $currencyCode
     */
    public function setCurrencyCode($currencyCode): void
    {
        $this->currencyCode = $currencyCode;
    }

    /**
     * @return mixed
     */
    public function getCurrencySymbol()
    {
        return $this->currencySymbol;
    }

    /**
     * @param mixed $currencySymbol
     */
    public function setCurrencySymbol($currencySymbol): void
    {
        $this->currencySymbol = $currencySymbol;
    }

    /**
     * @return mixed
     */
    public function getCurrencyDecimal()
    {
        return $this->currencyDecimal;
    }

    /**
     * @param mixed $currencyDecimal
     */
    public function setCurrencyDecimal($currencyDecimal): void
    {
        $this->currencyDecimal = $currencyDecimal;
    }

    /**
     * @return mixed
     */
    public function getCurrencyRate()
    {
        return $this->currencyRate;
    }

    /**
     * @param mixed $currencyRate
     */
    public function setCurrencyRate($currencyRate): void
    {
        $this->currencyRate = $currencyRate;
    }

    /**
     * @return mixed
     */
    public function getCurrencyType()
    {
        return $this->currencyType;
    }

    /**
     * @param mixed $currencyType
     */
    public function setCurrencyType($currencyType): void
    {
        $this->currencyType = $currencyType;
    }

    /**
     * @return mixed
     */
    public function getCurrencyState()
    {
        return $this->currencyState;
    }

    /**
     * @param mixed $currencyState
     */
    public function setCurrencyState($currencyState): void
    {
        $this->currencyState = $currencyState;
    }
}