<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * 配送设置
 * Class Delivery
 * @package Admin\Entity
 * @ORM\Entity(repositoryClass="Admin\Repository\DeliveryRepository")
 * @ORM\Table(name="dbshop_delivery")
 */
class Delivery extends BaseEntity
{
    /**
     * 配送id
     * @ORM\Id()
     * @ORM\Column(name="delivery_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $deliveryId;

    /**
     * 配送名称
     * @ORM\Column(name="delivery_name", type="string", length=200)
     */
    private $deliveryName;

    /**
     * 动态绑定编码
     * @ORM\Column(name="delivery_name_code", type="string", length=30)
     */
    private $deliveryNameCode;

    /**
     * 配送简介
     * @ORM\Column(name="delivery_info", type="string", length=1000)
     */
    private $deliveryInfo;

    /**
     * 配送公司网址
     * @ORM\Column(name="delivery_url", type="string", length=100)
     */
    private $deliveryUrl;

    /**
     * 排序
     * @ORM\Column(name="delivery_sort", type="integer", length=11)
     */
    private $deliverySort;

    /**
     * 配送状态（1 开启，0 关闭）
     * @ORM\Column(name="delivery_state", type="integer", length=1)
     */
    private $deliveryState;

    /**
     * 货到付款（1 支持，2 不支持）
     * @ORM\Column(name="cash_on_delivery", type="integer", length=1)
     */
    private $cashOnDelivery;

    /**
     * @return mixed
     */
    public function getDeliveryId()
    {
        return $this->deliveryId;
    }

    /**
     * @param mixed $deliveryId
     */
    public function setDeliveryId($deliveryId): void
    {
        $this->deliveryId = $deliveryId;
    }

    /**
     * @return mixed
     */
    public function getDeliveryName()
    {
        return $this->deliveryName;
    }

    /**
     * @param mixed $deliveryName
     */
    public function setDeliveryName($deliveryName): void
    {
        $this->deliveryName = $deliveryName;
    }

    /**
     * @return mixed
     */
    public function getDeliveryNameCode()
    {
        return $this->deliveryNameCode;
    }

    /**
     * @param mixed $deliveryNameCode
     */
    public function setDeliveryNameCode($deliveryNameCode): void
    {
        $this->deliveryNameCode = $deliveryNameCode;
    }

    /**
     * @return mixed
     */
    public function getDeliveryInfo()
    {
        return $this->deliveryInfo;
    }

    /**
     * @param mixed $deliveryInfo
     */
    public function setDeliveryInfo($deliveryInfo): void
    {
        $this->deliveryInfo = $deliveryInfo;
    }

    /**
     * @return mixed
     */
    public function getDeliveryUrl()
    {
        return $this->deliveryUrl;
    }

    /**
     * @param mixed $deliveryUrl
     */
    public function setDeliveryUrl($deliveryUrl): void
    {
        $this->deliveryUrl = $deliveryUrl;
    }

    /**
     * @return mixed
     */
    public function getDeliverySort()
    {
        return $this->deliverySort;
    }

    /**
     * @param mixed $deliverySort
     */
    public function setDeliverySort($deliverySort): void
    {
        $this->deliverySort = $deliverySort;
    }

    /**
     * @return mixed
     */
    public function getDeliveryState()
    {
        return $this->deliveryState;
    }

    /**
     * @param mixed $deliveryState
     */
    public function setDeliveryState($deliveryState): void
    {
        $this->deliveryState = $deliveryState;
    }

    /**
     * @return mixed
     */
    public function getCashOnDelivery()
    {
        return $this->cashOnDelivery;
    }

    /**
     * @param mixed $cashOnDelivery
     */
    public function setCashOnDelivery($cashOnDelivery): void
    {
        $this->cashOnDelivery = $cashOnDelivery;
    }
}