<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * 个性化区域
 * Class DeliveryIndividuation
 * @package Admin\Entity
 * @ORM\Entity(repositoryClass="Admin\Repository\DeliveryIndividuationRepository")
 * @ORM\Table(name="dbshop_delivery_individuation")
 */
class DeliveryIndividuation extends BaseEntity
{
    /**
     * 个性化id
     * @ORM\Id()
     * @ORM\Column(name="indiv_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $indivId;

    /**
     * 个性化费用（公式）
     * @ORM\Column(name="delivery_price", type="string", length=100)
     */
    private $deliveryPrice;

    /**
     * 个性化配送区域
     * @ORM\Column(name="delivery_area", type="text")
     */
    private $deliveryArea;

    /**
     * @return mixed
     */
    public function getIndivId()
    {
        return $this->indivId;
    }

    /**
     * @param mixed $deliveryId
     */
    public function setDeliveryId($deliveryId): void
    {
        $this->deliveryId = $deliveryId;
    }

    /**
     * @return mixed
     */
    public function getDeliveryPrice()
    {
        return $this->deliveryPrice;
    }

    /**
     * @param mixed $deliveryPrice
     */
    public function setDeliveryPrice($deliveryPrice): void
    {
        $this->deliveryPrice = $deliveryPrice;
    }

    /**
     * @return mixed
     */
    public function getDeliveryArea()
    {
        return $this->deliveryArea;
    }

    /**
     * @param mixed $deliveryArea
     */
    public function setDeliveryArea($deliveryArea): void
    {
        $this->deliveryArea = $deliveryArea;
    }
}