<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * 配送轨迹获取推送信息
 * Class ExpressPushReceive
 * @package Admin\Entity
 * @ORM\Entity(repositoryClass="Admin\Repository\ExpressPushReceiveRepository")
 * @ORM\Table(name="dbshop_express_push_receive")
 */
class ExpressPushReceive extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="receive_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $receiveId;

    /**
     * 订单id
     * @ORM\Column(name="order_id", type="integer", length=11)
     */
    private $orderId;

    /**
     * 配送公司代码
     * @ORM\Column(name="com_code", type="string", length=50)
     */
    private $comCode;

    /**
     * 配送单号
     * @ORM\Column(name="com_number", type="string", length=80)
     */
    private $comNumber;

    /**
     * 配送轨迹信息
     * @ORM\Column(name="receive_body", type="text")
     */
    private $receiveBody;

    /**
     * 更新时间
     * @ORM\Column(name="update_time", type="integer", length=10)
     */
    private $updateTime;

    /**
     * @return mixed
     */
    public function getReceiveId()
    {
        return $this->receiveId;
    }

    /**
     * @param mixed $receiveId
     */
    public function setReceiveId($receiveId): void
    {
        $this->receiveId = $receiveId;
    }

    /**
     * @return mixed
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * @param mixed $orderId
     */
    public function setOrderId($orderId): void
    {
        $this->orderId = $orderId;
    }

    /**
     * @return mixed
     */
    public function getComCode()
    {
        return $this->comCode;
    }

    /**
     * @param mixed $comCode
     */
    public function setComCode($comCode): void
    {
        $this->comCode = $comCode;
    }

    /**
     * @return mixed
     */
    public function getComNumber()
    {
        return $this->comNumber;
    }

    /**
     * @param mixed $comNumber
     */
    public function setComNumber($comNumber): void
    {
        $this->comNumber = $comNumber;
    }

    /**
     * @return mixed
     */
    public function getReceiveBody()
    {
        return $this->receiveBody;
    }

    /**
     * @param mixed $receiveBody
     */
    public function setReceiveBody($receiveBody): void
    {
        $this->receiveBody = $receiveBody;
    }

    /**
     * @return mixed
     */
    public function getUpdateTime()
    {
        return $this->updateTime;
    }

    /**
     * @param mixed $updateTime
     */
    public function setUpdateTime($updateTime): void
    {
        $this->updateTime = $updateTime;
    }
}