<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * 国际电话区号
 * Class PhoneAreaCode
 * @package Admin\Entity
 * @ORM\Entity(repositoryClass="Admin\Repository\PhoneAreaCodeRepository")
 * @ORM\Table(name="dbshop_phone_area_code")
 */
class PhoneAreaCode extends BaseEntity
{
    /**
     * 自增ID
     * @ORM\Id()
     * @ORM\Column(name="area_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $areaId;

    /**
     * 地区名称（国家地区）
     * @ORM\Column(name="area_name", type="string", length=100)
     */
    private $areaName;

    /**
     * 地区区号（国家地区）
     * @ORM\Column(name="area_code", type="string", length=10)
     */
    private $areaCode;

    /**
     * 电话区号
     * @ORM\Column(name="area_phone_code", type="string", length=10)
     */
    private $areaPhoneCode;

    /**
     * 排序
     * @ORM\Column(name="area_sort", type="integer", length=11)
     */
    private $areaSort;

    /**
     * 状态，1启用，0 禁用
     * @ORM\Column(name="area_state", type="integer", length=1)
     */
    private $areaState;

    /**
     * @return mixed
     */
    public function getAreaId()
    {
        return $this->areaId;
    }

    /**
     * @param mixed $areaId
     */
    public function setAreaId($areaId): void
    {
        $this->areaId = $areaId;
    }

    /**
     * @return mixed
     */
    public function getAreaName()
    {
        return $this->areaName;
    }

    /**
     * @param mixed $areaName
     */
    public function setAreaName($areaName): void
    {
        $this->areaName = $areaName;
    }

    /**
     * @return mixed
     */
    public function getAreaCode()
    {
        return $this->areaCode;
    }

    /**
     * @param mixed $areaCode
     */
    public function setAreaCode($areaCode): void
    {
        $this->areaCode = $areaCode;
    }

    /**
     * @return mixed
     */
    public function getAreaPhoneCode()
    {
        return $this->areaPhoneCode;
    }

    /**
     * @param mixed $areaPhoneCode
     */
    public function setAreaPhoneCode($areaPhoneCode): void
    {
        $this->areaPhoneCode = $areaPhoneCode;
    }

    /**
     * @return mixed
     */
    public function getAreaSort()
    {
        return $this->areaSort;
    }

    /**
     * @param mixed $areaSort
     */
    public function setAreaSort($areaSort): void
    {
        $this->areaSort = $areaSort;
    }

    /**
     * @return mixed
     */
    public function getAreaState()
    {
        return $this->areaState;
    }

    /**
     * @param mixed $areaState
     */
    public function setAreaState($areaState): void
    {
        $this->areaState = $areaState;
    }
}