<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * 商品自提点
 * Class SelfLocation
 * @package Admin\Entity
 * @ORM\Entity(repositoryClass="Admin\Repository\SelfLocationRepository")
 * @ORM\Table(name="dbshop_self_location")
 */
class SelfLocation extends BaseEntity
{
    /**
     * 自提点自增id
     * @ORM\Id()
     * @ORM\Column(name="location_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $locationId;

    /**
     * 自提点名称
     * @ORM\Column(name="location_name", type="string", length=200)
     */
    private $locationName;

    /**
     * 自提点地区id
     * @ORM\Column(name="region_id", type="integer", length=11)
     */
    private $regionId;

    /**
     * 自提点地区信息
     * @ORM\Column(name="region_info", type="string", length=150)
     */
    private $regionInfo;

    /**
     * 自提点详细地址
     * @ORM\Column(name="location_address", type="string", length=200)
     */
    private $locationAddress;

    /**
     * 自提点地理编码
     * @ORM\Column(name="location_geo_coding", type="string", length=50)
     */
    private $locationGeoCoding;

    /**
     * 自提点电话
     * @ORM\Column(name="location_phone", type="string", length=30)
     */
    private $locationPhone;

    /**
     * 自提点联系人
     * @ORM\Column(name="location_user", type="string", length=100)
     */
    private $locationUser;

    /**
     * 自提点营业时间
     * @ORM\Column(name="location_business_hours", type="string", length=200)
     */
    private $locationBusinessHours;

    /**
     * 排序
     * @ORM\Column(name="location_sort", type="integer", length=11)
     */
    private $locationSort;

    /**
     * 自提点状态，1 启用，0 禁用
     * @ORM\Column(name="location_state", type="integer", length=1)
     */
    private $locationState;

    /**
     * @return mixed
     */
    public function getLocationId()
    {
        return $this->locationId;
    }

    /**
     * @param mixed $locationId
     */
    public function setLocationId($locationId): void
    {
        $this->locationId = $locationId;
    }

    /**
     * @return mixed
     */
    public function getLocationName()
    {
        return $this->locationName;
    }

    /**
     * @param mixed $locationName
     */
    public function setLocationName($locationName): void
    {
        $this->locationName = $locationName;
    }

    /**
     * @return mixed
     */
    public function getRegionId()
    {
        return $this->regionId;
    }

    /**
     * @param mixed $regionId
     */
    public function setRegionId($regionId): void
    {
        $this->regionId = $regionId;
    }

    /**
     * @return mixed
     */
    public function getRegionInfo()
    {
        return $this->regionInfo;
    }

    /**
     * @param mixed $regionInfo
     */
    public function setRegionInfo($regionInfo): void
    {
        $this->regionInfo = $regionInfo;
    }

    /**
     * @return mixed
     */
    public function getLocationAddress()
    {
        return $this->locationAddress;
    }

    /**
     * @param mixed $locationAddress
     */
    public function setLocationAddress($locationAddress): void
    {
        $this->locationAddress = $locationAddress;
    }

    /**
     * @return mixed
     */
    public function getLocationGeoCoding()
    {
        return $this->locationGeoCoding;
    }

    /**
     * @param mixed $locationGeoCoding
     */
    public function setLocationGeoCoding($locationGeoCoding): void
    {
        $this->locationGeoCoding = $locationGeoCoding;
    }

    /**
     * @return mixed
     */
    public function getLocationPhone()
    {
        return $this->locationPhone;
    }

    /**
     * @param mixed $locationPhone
     */
    public function setLocationPhone($locationPhone): void
    {
        $this->locationPhone = $locationPhone;
    }

    /**
     * @return mixed
     */
    public function getLocationUser()
    {
        return $this->locationUser;
    }

    /**
     * @param mixed $locationUser
     */
    public function setLocationUser($locationUser): void
    {
        $this->locationUser = $locationUser;
    }

    /**
     * @return mixed
     */
    public function getLocationBusinessHours()
    {
        return $this->locationBusinessHours;
    }

    /**
     * @param mixed $locationBusinessHours
     */
    public function setLocationBusinessHours($locationBusinessHours): void
    {
        $this->locationBusinessHours = $locationBusinessHours;
    }

    /**
     * @return mixed
     */
    public function getLocationSort()
    {
        return $this->locationSort;
    }

    /**
     * @param mixed $locationSort
     */
    public function setLocationSort($locationSort): void
    {
        $this->locationSort = $locationSort;
    }

    /**
     * @return mixed
     */
    public function getLocationState()
    {
        return $this->locationState;
    }

    /**
     * @param mixed $locationState
     */
    public function setLocationState($locationState): void
    {
        $this->locationState = $locationState;
    }
}