<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * 模板数据表
 * Class Template
 * @package Admin\Entity
 * @ORM\Entity(repositoryClass="Admin\Repository\TemplateRepository")
 * @ORM\Table(name="dbshop_template")
 */
class Template extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="template_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $templateId;

    /**
     * 模板名称
     * @ORM\Column(name="template_name", type="string", length=50)
     */
    private $templateName;

    /**
     * 模板编码
     * @ORM\Column(name="template_code", type="string", length=50)
     */
    private $templateCode;

    /**
     * 模板语言
     * @ORM\Column(name="template_language", type="string", length=200)
     */
    private $templateLanguage = '';

    /**
     * 模板描述
     * @ORM\Column(name="template_info", type="string", length=500)
     */
    private $templateInfo;

    /**
     * 版本号，12位整数
     * @ORM\Column(name="template_version_number", type="integer", length=12)
     */
    private $templateVersionNumber;

    /**
     * 模板类型，如 手机（mobile），电脑(pc)
     * @ORM\Column(name="template_type", type="string", length=15)
     */
    private $templateType;

    /**
     * @return mixed
     */
    public function getTemplateId()
    {
        return $this->templateId;
    }

    /**
     * @param mixed $templateId
     */
    public function setTemplateId($templateId): void
    {
        $this->templateId = $templateId;
    }

    /**
     * @return mixed
     */
    public function getTemplateName()
    {
        return $this->templateName;
    }

    /**
     * @param mixed $templateName
     */
    public function setTemplateName($templateName): void
    {
        $this->templateName = $templateName;
    }

    /**
     * @return mixed
     */
    public function getTemplateCode()
    {
        return $this->templateCode;
    }

    /**
     * @param mixed $templateCode
     */
    public function setTemplateCode($templateCode): void
    {
        $this->templateCode = $templateCode;
    }

    /**
     * @return mixed
     */
    public function getTemplateLanguage()
    {
        return $this->templateLanguage;
    }

    /**
     * @param mixed $templateLanguage
     */
    public function setTemplateLanguage($templateLanguage): void
    {
        $this->templateLanguage = $templateLanguage;
    }

    /**
     * @return mixed
     */
    public function getTemplateInfo()
    {
        return $this->templateInfo;
    }

    /**
     * @param mixed $templateInfo
     */
    public function setTemplateInfo($templateInfo): void
    {
        $this->templateInfo = $templateInfo;
    }

    /**
     * @return mixed
     */
    public function getTemplateVersionNumber()
    {
        return $this->templateVersionNumber;
    }

    /**
     * @param mixed $templateVersionNumber
     */
    public function setTemplateVersionNumber($templateVersionNumber): void
    {
        $this->templateVersionNumber = $templateVersionNumber;
    }

    /**
     * @return mixed
     */
    public function getTemplateType()
    {
        return $this->templateType;
    }

    /**
     * @param mixed $templateType
     */
    public function setTemplateType($templateType): void
    {
        $this->templateType = $templateType;
    }
}