<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Filter;

use Admin\Data\Common;
use Admin\Data\Config;
use Imagine\Gd\Font;
use Imagine\Gd\Imagine;
use Imagine\Image\ImageInterface;
use Imagine\Image\Palette\RGB;
use Imagine\Image\Point;
use Laminas\Filter\AbstractFilter;

/**
 * 图片水印
 * Class ImageWatermark
 * @package Admin\Filter
 */
class ImageWatermark extends AbstractFilter
{
    private $waterType = 'text';
    private $waterConfig = [];

    public function __construct($options = [])
    {
        $this->waterConfig = Common::readConfigFile('upload');
    }

    public function filter($value)
    {
        if($this->waterConfig['watermark_state'] == 0 || $this->waterConfig['goods_watermark_state'] == 0) return $value;

        $image          = $value['tmp_name'];
        $imagine        = new Imagine();
        $sourceImage    = $imagine->open($image);

        if($this->waterConfig['watermark_type'] == 'image') {//水印图片
            $waterImage = $imagine->open(Config::PUBLIC_PATH . $this->waterConfig['watermark_image']);
            $point      = $this->waterImagePoint($this->waterConfig['watermark_location'], $sourceImage, $waterImage->getSize());
            $sourceImage->paste($waterImage, new Point($point['x'], $point['y']), $this->waterConfig['watermark_trans'])->save();
        } else {//水印文字
            if(empty($this->waterConfig['watermark_text'])) return $value;

            $palette  = new RGB();
            $font     = new Font(Config::COMMON_IMAGE_PATH . 'SourceHanSans-Normal.otf', $this->waterConfig['watermark_text_size'] * 10, $palette->color($this->waterConfig['watermark_text_color']));
            $size = $font->box($this->waterConfig['watermark_text'], $this->waterConfig['watermark_trans']);
            $point    = $this->waterImagePoint($this->waterConfig['watermark_location'], $sourceImage, $size, 30);

            $sourceImage->draw()->text(
                $this->waterConfig['watermark_text'],
                $font,
                new Point($point['x'], $point['y'])
            );
            $sourceImage->save();
        }

        return $value;
    }

    /**
     * 水印图片位置
     * @param $pos
     * @param ImageInterface $image
     * @param $waterImage
     * @param int $otherWidth
     * @return array
     */
    private function waterImagePoint($pos, ImageInterface $image, $waterImage, $otherWidth = 20)
    {
        switch ($pos) {
            case 1 ://顶部左边
                $dstX = 10;
                $dstY = 5;
                break;
            case 2 ://顶部中间
                $dstX = ($image->getSize()->getWidth() - $waterImage->getWidth()) / 2;
                $dstY = 5;
                break;
            case 3 ://顶部右边
                $dstX = $image->getSize()->getWidth() - $waterImage->getWidth() - $otherWidth;
                $dstY = 5;
                break;
            case 4 ://中部左边
                $dstX = 10;
                $dstY = ($image->getSize()->getHeight() - $waterImage->getHeight())/2;
                break;
            case 5 ://中部中间
                $dstX = ($image->getSize()->getWidth() - $waterImage->getWidth())/2;
                $dstY = ($image->getSize()->getHeight() - $waterImage->getHeight())/2;
                break;
            case 6 ://中部右边
                $dstX = $image->getSize()->getWidth() - $waterImage->getWidth() - $otherWidth;
                $dstY = ($image->getSize()->getHeight() - $waterImage->getHeight())/2;
                break;
            case 7 ://底部左边
                $dstX = 10;
                $dstY = $image->getSize()->getHeight() - $waterImage->getHeight() - 10;
                break;
            case 8 ://底部中间
                $dstX = ($image->getSize()->getWidth() - $waterImage->getWidth())/2;
                $dstY = $image->getSize()->getHeight() - $waterImage->getHeight() - 10;
                break;
            case 9 ://底部右边
                $dstX = $image->getSize()->getWidth() - $waterImage->getWidth() - $otherWidth;
                $dstY = $image->getSize()->getHeight() - $waterImage->getHeight() - 10;
                break;
            default://随机位置
                $dstX = mt_rand(0, $image->getSize()->getWidth() - $waterImage->getWidth());
                $dstY = mt_rand(0, $image->getSize()->getHeight() - $waterImage->getHeight());
                break;
        }

        return ['x' => $dstX, 'y' => $dstY];
    }
}