<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Form;

use Laminas\Form\Form;

class AdminUserLoginForm extends Form
{
    private $captcha;

    public function __construct($captcha, $name = 'admin-login', array $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'post');
        $this->captcha = $captcha;

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'admin_name',
            'attributes'    => [
                'id'            => 'admin_name',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'password',
            'name'  => 'admin_passwd',
            'attributes'    => [
                'id'            => 'admin_passwd',
                'class'         => 'form-control'
            ]
        ]);

        if ($this->captcha) {
            $this->add([
                'type'  => 'captcha',
                'name' => 'login_captcha',
                'attributes'    => [
                    'id'            => 'login_captcha',
                    'class'         => 'form-control'
                ],
                'options' => [
                    'captcha' => [
                        'class' => 'Figlet',
                        'wordLen' => 4,
                        'expiration' => 180
                    ],
                ],
            ]);
        }

        $this->add([
            'type'  => 'csrf',
            'name'  => 'login_csrf',
            'options' => [
                'csrf_options' => [
                    'timeout'  => 180
                ]
            ]
        ]);

        $this->add([
            'type'  => 'submit',
            'name'  => 'submit-login',
            'attributes'    => [
                'id'    => 'submit-login',
                'class' => 'btn btn-primary btn-block btn-flat'
            ],
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'admin_name',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'admin_passwd',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim']
            ]
        ]);
    }
}