<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Form;

use Admin\Data\Common;
use Admin\Data\Config;
use Laminas\Form\Form;
use Laminas\I18n\Translator\Translator;

class CustomerSetForm extends Form
{
    private $translator;

    public function __construct($name = 'customer-set-form', $options = [])
    {
        parent::__construct($name, $options);
        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');

        $this->translator = new Translator();

        $this->addElements();
        $this->addInputFilter();
    }

    public function addElements()
    {
        /*=============================基本设置=============================*/
        $this->add([
            'type'  => 'radio',
            'name'  => 'register_status',
            'options' => [
                'label_attributes' => [
                    'class' => 'radio-inline'
                ],
                'disable_inarray_validator' => true
            ],
            'attributes'    => [
                'value'         => 1
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'register_close_message',
            'attributes'    => [
                'id'    => 'register_close_message',
                'class' => 'form-control',
                'rows'  => 4
            ]
        ]);

        $this->add([
            'type'  => 'file',
            'name'  => 'default_user_avatar',
            'attributes'    => [
                'id'            => 'default_user_avatar',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'default_user_group_id',
            'attributes'    => [
                'id'            => 'default_user_group_id',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'user_register_audit',
            'attributes'    => [
                'id'            => 'user_register_audit',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'user_register_retain',
            'attributes'    => [
                'id'    => 'user_register_retain',
                'class' => 'form-control',
                'rows'  => 4
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'register_welcome_email',
            'attributes'    => [
                'id'            => 'register_welcome_email',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'welcome_email_title',
            'attributes'    => [
                'id'            => 'welcome_email_title',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'welcome_email_body',
            'attributes'    => [
                'id'    => 'welcome_email_body',
                'class' => 'form-control',
                'rows'  => 5
            ]
        ]);

        /*=============================客户协议=============================*/
        $this->add([
            'type'  => 'textarea',
            'name'  => 'register_agreement',
            'attributes'    => [
                'id'    => 'register_agreement',
                'class' => 'form-control',
                'rows'  => 6
            ]
        ]);

        /*=============================登录注册=============================*/
        $this->add([
            'type'  => 'checkbox',
            'name'  => 'register_email_state',
            'attributes'    => [
                'id'            => 'register_email_state'
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'register_phone_state',
            'attributes'    => [
                'id'            => 'register_phone_state'
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'register_phone_captcha',
            'attributes'    => [
                'id'            => 'register_phone_captcha'
            ]
        ]);

        $this->add([
            'type'  => 'multiCheckbox',
            'name'  => 'login_item',
            'options' => [
                'label_attributes' => [
                    'class' => 'checkbox-inline'
                ]
            ]
        ]);

        /*=============================第三方登录=============================*/
        $this->add([
            'type'  => 'checkbox',
            'name'  => 'qq_login_state',
            'attributes'    => [
                'id'            => 'qq_login_state',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'qq_app_id',
            'attributes'    => [
                'id'            => 'qq_app_id',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'qq_app_key',
            'attributes'    => [
                'id'            => 'qq_app_key',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'weixin_login_state',
            'attributes'    => [
                'id'            => 'weixin_login_state',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'weixin_app_id',
            'attributes'    => [
                'id'            => 'weixin_app_id',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'weixin_app_key',
            'attributes'    => [
                'id'            => 'weixin_app_key',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'weixin_web_login_state',
            'attributes'    => [
                'id'            => 'weixin_web_login_state',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'weixin_web_app_id',
            'attributes'    => [
                'id'            => 'weixin_web_app_id',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'weixin_web_app_key',
            'attributes'    => [
                'id'            => 'weixin_web_app_key',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'alipay_login_state',
            'attributes'    => [
                'id'            => 'alipay_login_state',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'alipay_app_id',
            'attributes'    => [
                'id'            => 'alipay_app_id',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'alipay_private_key',
            'attributes'    => [
                'id'    => 'alipay_private_key',
                'class' => 'form-control',
                'rows'  => 5
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'alipay_public_key',
            'attributes'    => [
                'id'    => 'alipay_public_key',
                'class' => 'form-control',
                'rows'  => 5
            ]
        ]);

        /*=============================充值与提现=============================*/
        $this->add([
            'type'  => 'checkbox',
            'name'  => 'recharge_state',
            'attributes'    => [
                'id'            => 'recharge_state',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'checkbox',
            'name'  => 'withdraw_state',
            'attributes'    => [
                'id'            => 'withdraw_state',
                'class'         => 'form-control'
            ]
        ]);

        /*=============================验证设置=============================*/
        /*$this->add([
            'type'  => 'select',
            'name'  => 'user_login_password_edit',
            'attributes'    => [
                'id'            => 'user_login_password_edit',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'select',
            'name'  => 'user_pay_password_edit',
            'attributes'    => [
                'id'            => 'user_pay_password_edit',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'select',
            'name'  => 'user_email_edit',
            'attributes'    => [
                'id'            => 'user_email_edit',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'select',
            'name'  => 'user_phone_edit',
            'attributes'    => [
                'id'            => 'user_phone_edit',
                'class'         => 'form-control'
            ]
        ]);*/
    }

    public function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'register_status',
            'required'  => true,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [1, 0]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'register_close_message',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'type'      => 'Laminas\InputFilter\FileInput',
            'name'      => 'default_user_avatar',
            'required'  => false,
            'validators'=> [
                ['name' => 'FileUploadFile'],
                [
                    'name' => 'FileMimeType',
                    'options' => [
                        'mimeType' => Common::configValue('image_type')
                    ]
                ],
                ['name' => 'FileIsImage'],
                [
                    'name' => 'FileSize',
                    'options' => Common::configValue('upload_image_max')
                ]
            ],
            'filters'  => [
                [
                    'name' => 'FileRenameUpload',
                    'options' => [
                        'target' => Config::COMMON_IMAGE_PATH . 'default_user_avatar.png',
                        'overwrite'=>true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'default_user_group_id',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'user_register_retain',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'register_welcome_email',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'welcome_email_title',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'welcome_email_body',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim']
            ]
        ]);

        /*=============================客户协议=============================*/
        $inputFilter->add([
            'name'      => 'register_agreement',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim']
            ]
        ]);

        /*=============================登录注册=============================*/
        $inputFilter->add([
            'name'      => 'register_email_state',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'register_phone_state',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'login_item',
            'required'  => false
        ]);

        /*=============================第三方登录=============================*/
        $inputFilter->add([
            'name'      => 'qq_login_state',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'qq_app_id',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'qq_app_key',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'weixin_login_state',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'weixin_app_id',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'weixin_app_key',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'weixin_web_login_state',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'weixin_web_app_id',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'weixin_web_app_key',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'alipay_login_state',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'alipay_app_id',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'alipay_private_key',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'alipay_public_key',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        /*=============================充值与提现=============================*/
        $inputFilter->add([
            'name'      => 'recharge_state',
            'required'  => true,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [1, 0]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'withdraw_state',
            'required'  => true,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [1, 0]
                    ]
                ]
            ]
        ]);
    }
}