<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Form;

use Admin\Data\Config;
use Laminas\Form\Form;

class DeliveryForm extends Form
{
    public function __construct($name = 'delivery-form', $options = [])
    {
        parent::__construct($name, $options);
        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'deliveryName',
            'attributes'    => [
                'id'            => 'deliveryName',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'deliveryInfo',
            'attributes'    => [
                'id'            => 'deliveryInfo',
                'class'         => 'form-control',
                'rows'          => 3
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'deliveryUrl',
            'attributes'    => [
                'id'            => 'deliveryUrl',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'deliveryNameCode',
            'attributes'    => [
                'id'            => 'deliveryNameCode',
                'class'         => 'form-control select2'
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'cashOnDelivery',
            'attributes'    => [
                'id'            => 'cashOnDelivery',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'deliveryState',
            'attributes' => [
                'value' => 1
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'deliverySort',
            'attributes'    => [
                'id'            => 'deliverySort',
                'class'         => 'form-control',
                'value'         => 255
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'deliveryName',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'deliveryInfo',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'deliveryUrl',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'cashOnDelivery',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'deliveryState',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'deliverySort',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ]
        ]);

    }
}