<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Form;

use Laminas\Form\Form;

class EmailMessageForm extends Form
{
    public function __construct($name = 'email-message-form', array $options = [])
    {
        parent::__construct($name, $options);
        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'textarea',
            'name'  => 'adminEmail',
            'attributes'    => [
                'id'    => 'adminEmail',
                'class' => 'form-control',
                'rows'  => 6
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'adminAddOrderSend',
            'attributes' => [
                'value' => 1
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'buyerAddOrderSend',
            'attributes' => [
                'value' => 1
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'addOrderEmailBody',
            'attributes'    => [
                'id'    => 'addOrderEmailBody',
                'class' => 'form-control',
                'rows'  => 6
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'adminPaymentOrderSend',
            'attributes' => [
                'value' => 1
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'buyerPaymentOrderSend',
            'attributes' => [
                'value' => 1
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'paymentOrderEmailBody',
            'attributes'    => [
                'id'    => 'paymentOrderEmailBody',
                'class' => 'form-control',
                'rows'  => 6
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'adminShipOrderSend',
            'attributes' => [
                'value' => 1
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'buyerShipOrderSend',
            'attributes' => [
                'value' => 1
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'shipOrderEmailBody',
            'attributes'    => [
                'id'    => 'shipOrderEmailBody',
                'class' => 'form-control',
                'rows'  => 6
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'adminReceiptOrderSend',
            'attributes' => [
                'value' => 1
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'buyerReceiptOrderSend',
            'attributes' => [
                'value' => 1
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'receiptOrderEmailBody',
            'attributes'    => [
                'id'    => 'receiptOrderEmailBody',
                'class' => 'form-control',
                'rows'  => 6
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'adminCancelOrderSend',
            'attributes' => [
                'value' => 1
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'buyerCancelOrderSend',
            'attributes' => [
                'value' => 1
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'cancelOrderEmailBody',
            'attributes'    => [
                'id'    => 'cancelOrderEmailBody',
                'class' => 'form-control',
                'rows'  => 6
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'adminGoodsStockOutSend',
            'attributes' => [
                'value' => 1
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'goodsStockOutEmailBody',
            'attributes'    => [
                'id'    => 'goodsStockOutEmailBody',
                'class' => 'form-control',
                'rows'  => 6
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'adminVirtualGoodsSend',
            'attributes' => [
                'value' => 1
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'buyerVirtualGoodsSend',
            'attributes' => [
                'value' => 1
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'virtualGoodsEmailBody',
            'attributes'    => [
                'id'    => 'virtualGoodsEmailBody',
                'class' => 'form-control',
                'rows'  => 6
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'adminEmail',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'adminAddOrderSend',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'buyerAddOrderSend',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'addOrderEmailBody',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'adminPaymentOrderSend',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'buyerPaymentOrderSend',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'paymentOrderEmailBody',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'adminShipOrderSend',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'buyerShipOrderSend',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'shipOrderEmailBody',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'adminReceiptOrderSend',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'buyerReceiptOrderSend',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'receiptOrderEmailBody',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'adminCancelOrderSend',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'buyerCancelOrderSend',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'cancelOrderEmailBody',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'adminGoodsStockOutSend',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goodsStockOutEmailBody',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'adminVirtualGoodsSend',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'buyerVirtualGoodsSend',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'virtualGoodsEmailBody',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);
    }
}