<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Form;

use Laminas\Form\Form;

class PhoneSmsForm extends Form
{
    private $phoneArea;

    public function __construct(array $phoneArea, $name = 'phone-sms-form', array $options = [])
    {
        parent::__construct($name, $options);
        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');

        $this->phoneArea    = $phoneArea;

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        if(count($this->phoneArea) == 1) {
            $this->add([
                'type'  => 'hidden',
                'name'  => 'areaCode',
                'attributes'=> [
                    'id'    => 'areaCode',
                    'value' => $this->phoneArea[0]['areaCode']
                ]
            ]);
        } else {
            $this->add([
                'type'  => 'select',
                'name'  => 'areaCode',
                'attributes'=> [
                    'id'    => 'areaCode',
                    'class' => 'form-control',
                    'value' => $this->phoneArea['default']
                ],
                'options' => [
                    'value_options' => $this->phoneArea['list']
                ]
            ]);
        }

        $this->add([
            'type'  => 'text',
            'name'  => 'adminPhone',
            'attributes'    => [
                'id'    => 'adminPhone',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'multiCheckbox',
            'name'  => 'adminPhoneSend',
            'options' => [
                'label_attributes' => [
                    'class' => 'checkbox-inline'
                ]
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'addOrderSmsTemplateId',
            'attributes'    => [
                'id'    => 'addOrderSmsTemplateId',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'paymentOrderSmsTemplateId',
            'attributes'    => [
                'id'    => 'paymentOrderSmsTemplateId',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'shipOrderSmsTemplateId',
            'attributes'    => [
                'id'    => 'shipOrderSmsTemplateId',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'receiptOrderSmsTemplateId',
            'attributes'    => [
                'id'    => 'receiptOrderSmsTemplateId',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'cancelOrderSmsTemplateId',
            'attributes'    => [
                'id'    => 'cancelOrderSmsTemplateId',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'captchaSmsTemplateId',
            'attributes'    => [
                'id'    => 'captchaSmsTemplateId',
                'class' => 'form-control'
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'adminPhone',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'adminPhoneSend',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'addOrderSmsTemplateId',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'paymentOrderSmsTemplateId',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'shipOrderSmsTemplateId',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'receiptOrderSmsTemplateId',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'cancelOrderSmsTemplateId',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'captchaSmsTemplateId',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);
    }
}