<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Form;

use Laminas\Form\Form;

class SelfLocationForm extends Form
{
    public function __construct($name = 'self-location-form', array $options = [])
    {
        parent::__construct($name, $options);
        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'locationName',
            'attributes'    => [
                'id'            => 'locationName',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'hidden',
            'name'  => 'regionId',
            'attributes'    => [
                'id'            => 'regionId',
                'class'         => 'region_ids'
            ]
        ]);

        $this->add([
            'type'  => 'hidden',
            'name'  => 'regionInfo',
            'attributes'    => [
                'id'            => 'regionInfo',
                'class'         => 'region_names'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'locationAddress',
            'attributes'    => [
                'id'            => 'locationAddress',
                'class'         => 'form-control'
            ]
        ]);

        /*$this->add([
            'type'  => 'text',
            'name'  => 'locationGeoCoding',
            'attributes'    => [
                'id'            => 'locationGeoCoding',
                'class'         => 'form-control',
                'readonly'  => true
            ]
        ]);*/

        $this->add([
            'type'  => 'text',
            'name'  => 'locationPhone',
            'attributes'    => [
                'id'            => 'locationPhone',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'locationUser',
            'attributes'    => [
                'id'            => 'locationUser',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'locationBusinessHours',
            'attributes'    => [
                'id'    => 'locationBusinessHours',
                'class' => 'form-control',
                'rows'  => 4
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'locationSort',
            'attributes'    => [
                'id'        => 'locationSort',
                'class'     => 'form-control',
                'value'     => 255,
                'min'       => 1
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'locationState',
            'attributes'    => [
                'id'            => 'locationState',
                'value'         => 1
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'locationName',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 200
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'regionId',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0,
                        'inclusive' => true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'regionInfo',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'locationAddress',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 200
                    ]
                ]
            ]
        ]);

        /*$inputFilter->add([
            'name'      => 'locationGeoCoding',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'max'   => 50
                    ]
                ]
            ]
        ]);*/

        $inputFilter->add([
            'name'      => 'locationPhone',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'locationUser',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'locationBusinessHours',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'max'   => 200
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'locationSort',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'locationState',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);
    }
}