<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Form;

use Laminas\Form\Form;

class ShopDeliveryForm extends Form
{
    public function __construct($name = 'shop-delivery-form', $options = [])
    {
        parent::__construct($name, $options);
        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'select',
            'name'  => 'cashOnDelivery',
            'attributes'    => [
                'id'            => 'cashOnDelivery',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'deliveryState',
            'attributes' => [
                'value' => 1
            ]
        ]);

        $this->add([
            'type'  => 'radio',
            'name'  => 'deliverySet',
            'options' => [
                'disable_inarray_validator' => true,
                'label_attributes' => [
                    'class' => 'radio-inline'
                ]
            ],
            'attributes'    => [
                'value'         => 'T'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'deliveryPrice',
            'attributes'    => [
                'id'            => 'deliveryPrice',
                'class'         => 'form-control',
                'value'         => 0
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'deliveryApiType',
            'attributes'    => [
                'id'            => 'deliveryApiType',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'deliveryApiSecret',
            'attributes'    => [
                'id'            => 'deliveryApiSecret',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'pushOrderFinish'
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'deliveryApiKey',
            'attributes'    => [
                'id'            => 'deliveryApiKey',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'deliveryApiState'
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'cashOnDelivery',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'deliveryState',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'deliverySet',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'deliveryPrice',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'deliveryApiSecret',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'deliveryApiKey',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'pushOrderFinish',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'deliveryApiState',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);
    }
}