<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Form;

use Admin\Data\Common;
use Admin\Data\Config;
use Admin\Filter\ImageThumb;
use Laminas\Form\Form;

class SystemForm extends Form
{
    public function __construct($name = 'system-form', array $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'post');
        $this->setAttribute('enctype', 'multipart/form-data');
        $this->setAttribute('class', 'form-horizontal');

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        /*=============================基本设置=============================*/
        $this->add([
            'type'  => 'text',
            'name'  => 'shop_name|base',
            'attributes'    => [
                'id'            => 'shop_name|base',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'shop_extend_name|base',
            'attributes'    => [
                'id'            => 'shop_extend_name|base',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'shop_keywords|base',
            'attributes'    => [
                'id'            => 'shop_keywords|base',
                'class'         => 'form-control',
                'rows'          => 2
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'shop_description|base',
            'attributes'    => [
                'id'            => 'shop_description|base',
                'class'         => 'form-control',
                'rows'          => 3
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'shop_place_keywords|base',
            'attributes'    => [
                'id'        => 'shop_place_keywords|base',
                'class'     => 'form-control',
                'value'     => '简简单单搜索'
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'shop_hot_keywords|base',
            'attributes'    => [
                'id'            => 'shop_hot_keywords|base',
                'class'         => 'form-control',
                'rows'          => 2
            ]
        ]);

        $this->add([
            'type'  => 'file',
            'name'  => 'shop_logo|base',
            'attributes'    => [
                'id'            => 'shop_logo|base',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'file',
            'name'  => 'shop_favicon|base',
            'attributes'    => [
                'id'            => 'shop_favicon|base',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'website_icp|base',
            'attributes'    => [
                'id'            => 'website_icp|base',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'website_close|base',
            'attributes'    => [
                'id'            => 'website_close|base',
                'value'         => 1
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'website_close_info|base',
            'attributes'    => [
                'id'            => 'website_close_info|base',
                'class'         => 'form-control',
                'rows'          => 3
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'a_language|base',
            'attributes'    => [
                'id'            => 'a_language|base',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'f_language|base',
            'attributes'    => [
                'id'            => 'f_language|base',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'website_timezone|base',
            'attributes'    => [
                'id'            => 'website_timezone|base',
                'class'         => 'form-control'
            ]
        ]);

        /*=============================验证码=============================*/
        $this->add([
            'type'  => 'checkbox',
            'name'  => 'user_register_captcha|captcha',
            'attributes'    => [
                'id'            => 'user_register_captcha|captcha',
                'value'         => 1
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'user_login_captcha|captcha',
            'attributes'    => [
                'id'            => 'user_login_captcha|captcha',
                'value'         => 1
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'goods_ask_captcha|captcha',
            'attributes'    => [
                'id'            => 'goods_ask_captcha|captcha',
                'value'         => 1
            ]
        ]);

        /*=============================邮件服务器=============================*/
        $this->add([
            'type'  => 'checkbox',
            'name'  => 'email_service_state|email',
            'attributes'    => [
                'id'            => 'email_service_state|email',
                'value'         => 0
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'email_service_type|email',
            'attributes'    => [
                'id'            => 'email_service_type-email',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'dbshop_email_service_password|email',
            'attributes'    => [
                'id'            => 'dbshop_email_service_password|email',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'send_from_mail|email',
            'attributes'    => [
                'id'            => 'send_from_mail|email',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'send_name|email',
            'attributes'    => [
                'id'            => 'send_name|email',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'smtp_location|email',
            'attributes'    => [
                'id'            => 'smtp_location|email',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'smtp_port|email',
            'attributes'    => [
                'id'            => 'smtp_port|email',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'smtp_name|email',
            'attributes'    => [
                'id'            => 'smtp_name|email',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'smtp_password|email',
            'attributes'    => [
                'id'            => 'smtp_password|email',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'smtp_check|email',
            'attributes'    => [
                'id'            => 'smtp_check|email',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'smtp_secure_conn|email',
            'attributes'    => [
                'id'            => 'smtp_secure_conn|email',
                'class'         => 'form-control'
            ]
        ]);

        /*=============================短信服务设置=============================*/
        $this->add([
            'type'  => 'checkbox',
            'name'  => 'sms_state|sms',
            'attributes'    => [
                'id'            => 'sms_state|sms',
                'value'         => 0
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'sms_service_provider|sms',
            'attributes'    => [
                'id'            => 'sms_service_provider-sms',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'sms_sign_name|sms',
            'attributes'    => [
                'id'            => 'sms_sign_name|sms',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'sms_id|sms',
            'attributes'    => [
                'id'            => 'sms_id|sms',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'sms_secret|sms',
            'attributes'    => [
                'id'            => 'sms_secret|sms',
                'class'         => 'form-control'
            ]
        ]);

        //只应用于腾讯短信
        $this->add([
            'type'  => 'text',
            'name'  => 'sms_sdk_id|sms',
            'attributes'    => [
                'id'            => 'sms_sdk_id|sms',
                'class'         => 'form-control'
            ]
        ]);

        /*=============================商品设置=============================*/
        $this->add([
            'type'  => 'text',
            'name'  => 'goods_sn_prefix|goods',
            'attributes'    => [
                'id'            => 'goods_sn_prefix|goods',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'goods_group_price_show|goods',
            'attributes'    => [
                'id'            => 'goods_group_price_show|goods',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'login_goods_price_show|goods',
            'attributes'    => [
                'id'            => 'login_goods_price_show|goods',
                'value'         => 0
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'goods_consultation_state|goods',
            'attributes'    => [
                'id'            => 'goods_consultation_state|goods',
                'value'         => 0
            ]
        ]);

        /*=============================订单设置=============================*/
        $this->add([
            'type'  => 'checkbox',
            'name'  => 'order_return|order',
            'attributes'    => [
                'id'            => 'order_return|order',
                'value'         => 0
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'order_return_limit|order',
            'attributes'    => [
                'id'            => 'order_return_limit|order',
                'class'         => 'form-control',
                'min'           => 1,
                'value'         => 7
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'order_return_cause|order',
            'attributes'    => [
                'id'           => 'order_return_cause|order',
                'class'        => 'form-control',
                'rows'         => 6
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'delivery_time_state|order',
            'attributes'    => [
                'id'            => 'delivery_time_state|order',
                'value'         => 0
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'delivery_time|order',
            'attributes'    => [
                'id'            => 'delivery_time|order',
                'class'         => 'form-control',
                'rows'          => 6
            ]
        ]);

        /*=============================统计设置=============================*/
        $this->add([
            'type'  => 'textarea',
            'name'  => 'statistics_code|statistics',
            'attributes'    => [
                'id'            => 'statistics_code|statistics',
                'class'         => 'form-control',
                'rows'          => 8
            ]
        ]);

        /*=============================二维码设置=============================*/
        $this->add([
            'type'  => 'checkbox',
            'name'  => 'website_qr_code|qr_code',
            'attributes'    => [
                'id'            => 'website_qr_code|qr_code',
                'value'         => 1
            ]
        ]);
        $this->add([
            'type'  => 'checkbox',
            'name'  => 'goods_qr_code|qr_code',
            'attributes'    => [
                'id'            => 'goods_qr_code|qr_code',
                'value'         => 0
            ]
        ]);

        /*=============================内容设置=============================*/
        $this->add([
            'type'  => 'textarea',
            'name'  => 'goods_quality|content',
            'attributes'    => [
                'id'            => 'goods_quality|content',
                'class'         => 'form-control',
                'rows'          => 4
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'sales_service|content'
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'buy_service|content'
        ]);

        /*=============================前台底部=============================*/
        $this->add([
            'type'  => 'file',
            'name'  => 'shop_footer_image_1|shop_footer',
            'attributes'    => [
                'id'            => 'shop_footer_image_1|shop_footer',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'text',
            'name'  => 'shop_footer_image_1_url|shop_footer',
            'attributes'    => [
                'id'            => 'shop_footer_image_1_url|shop_footer',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'file',
            'name'  => 'shop_footer_image_2|shop_footer',
            'attributes'    => [
                'id'            => 'shop_footer_image_2|shop_footer',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'text',
            'name'  => 'shop_footer_image_2_url|shop_footer',
            'attributes'    => [
                'id'            => 'shop_footer_image_2_url|shop_footer',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'file',
            'name'  => 'shop_footer_image_3|shop_footer',
            'attributes'    => [
                'id'            => 'shop_footer_image_3|shop_footer',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'text',
            'name'  => 'shop_footer_image_3_url|shop_footer',
            'attributes'    => [
                'id'            => 'shop_footer_image_3_url|shop_footer',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'file',
            'name'  => 'shop_footer_image_4|shop_footer',
            'attributes'    => [
                'id'            => 'shop_footer_image_4|shop_footer',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'text',
            'name'  => 'shop_footer_image_4_url|shop_footer',
            'attributes'    => [
                'id'            => 'shop_footer_image_4_url|shop_footer',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'file',
            'name'  => 'shop_footer_image_5|shop_footer',
            'attributes'    => [
                'id'            => 'shop_footer_image_5|shop_footer',
                'class'         => 'form-control'
            ]
        ]);
        $this->add([
            'type'  => 'text',
            'name'  => 'shop_footer_image_5_url|shop_footer',
            'attributes'    => [
                'id'            => 'shop_footer_image_5_url|shop_footer',
                'class'         => 'form-control'
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'shop_name|base',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'shop_extend_name|base',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'shop_keywords|base',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'shop_description|base',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'shop_place_keywords|base',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'shop_hot_keywords|base',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'type'      => 'Laminas\InputFilter\FileInput',
            'name'      => 'shop_logo|base',
            'required'  => false,
            'validators'=> [
                ['name' => 'FileUploadFile'],
                [
                    'name' => 'FileMimeType',
                    'options' => [
                        'mimeType' => Common::configValue('image_type')
                    ]
                ],
                ['name' => 'FileIsImage'],
                [
                    'name' => 'FileSize',
                    'options' => Common::configValue('upload_image_max')
                ]
            ],
            'filters'  => [
                [
                    'name' => 'FileRenameUpload',
                    'options' => [
                        'target' => Config::COMMON_IMAGE_PATH . 'logo.png',
                        'overwrite'=>true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'type'      => 'Laminas\InputFilter\FileInput',
            'name'      => 'shop_favicon|base',
            'required'  => false,
            'validators'=> [
                ['name' => 'FileUploadFile'],
                [
                    'name' => 'FileMimeType',
                    'options' => [
                        'mimeType' => ['image/jpeg', 'image/png', 'image/x-ico', 'image/x-icon']
                    ]
                ],
                ['name' => 'FileIsImage'],
                [
                    'name' => 'FileSize',
                    'options' => Common::configValue('upload_image_max')
                ]
            ],
            'filters'  => [
                [
                    'name' => 'FileRenameUpload',
                    'options' => [
                        'target' => Config::COMMON_IMAGE_PATH . 'favicon.ico',
                        'overwrite'=>true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'website_icp|base',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'website_close|base',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'website_close_info|base',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'website_timezone|base',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'user_register_captcha|captcha',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'user_login_captcha|captcha',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goods_ask_captcha|captcha',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'email_service_state|email',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'send_from_mail|email',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'send_name|email',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'smtp_location|email',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'smtp_port|email',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'smtp_name|email',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'smtp_password|email',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'smtp_check|email',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'smtp_secure_conn|email',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'sms_state|sms',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'sms_service_provider|sms',
            'required'  => true
        ]);

        $inputFilter->add([
            'name'      => 'sms_sign_name|sms',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'sms_id|sms',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'sms_secret|sms',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goods_sn_prefix|goods',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goods_group_price_show|goods',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'login_goods_price_show|goods',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goods_consultation_state|goods',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'order_return|order',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'order_return_limit|order',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'order_return_cause|order',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'delivery_time_state|order',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'delivery_time|order',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'statistics_code|statistics',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'website_qr_code|qr_code',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goods_qr_code|qr_code',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goods_quality|content',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'type'      => 'Laminas\InputFilter\FileInput',
            'name'      => 'shop_footer_image_1|shop_footer',
            'required'  => false,
            'validators'=> [
                ['name' => 'FileUploadFile'],
                [
                    'name' => 'FileMimeType',
                    'options' => [
                        'mimeType' => Common::configValue('image_type')
                    ]
                ],
                ['name' => 'FileIsImage'],
                [
                    'name' => 'FileSize',
                    'options' => Common::configValue('upload_image_max')
                ]
            ],
            'filters'  => [
                [
                    'name' => 'FileRenameUpload',
                    'options' => [
                        'target' => Config::COMMON_IMAGE_PATH . 'shop_footer_image_1.png',
                        'overwrite'=>true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'shop_footer_image_1_url|shop_footer',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'type'      => 'Laminas\InputFilter\FileInput',
            'name'      => 'shop_footer_image_2|shop_footer',
            'required'  => false,
            'validators'=> [
                ['name' => 'FileUploadFile'],
                [
                    'name' => 'FileMimeType',
                    'options' => [
                        'mimeType' => Common::configValue('image_type')
                    ]
                ],
                ['name' => 'FileIsImage'],
                [
                    'name' => 'FileSize',
                    'options' => Common::configValue('upload_image_max')
                ]
            ],
            'filters'  => [
                [
                    'name' => 'FileRenameUpload',
                    'options' => [
                        'target' => Config::COMMON_IMAGE_PATH . 'shop_footer_image_2.png',
                        'overwrite'=>true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'shop_footer_image_2_url|shop_footer',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'type'      => 'Laminas\InputFilter\FileInput',
            'name'      => 'shop_footer_image_3|shop_footer',
            'required'  => false,
            'validators'=> [
                ['name' => 'FileUploadFile'],
                [
                    'name' => 'FileMimeType',
                    'options' => [
                        'mimeType' => Common::configValue('image_type')
                    ]
                ],
                ['name' => 'FileIsImage'],
                [
                    'name' => 'FileSize',
                    'options' => Common::configValue('upload_image_max')
                ]
            ],
            'filters'  => [
                [
                    'name' => 'FileRenameUpload',
                    'options' => [
                        'target' => Config::COMMON_IMAGE_PATH . 'shop_footer_image_3.png',
                        'overwrite'=>true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'shop_footer_image_3_url|shop_footer',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'type'      => 'Laminas\InputFilter\FileInput',
            'name'      => 'shop_footer_image_4|shop_footer',
            'required'  => false,
            'validators'=> [
                ['name' => 'FileUploadFile'],
                [
                    'name' => 'FileMimeType',
                    'options' => [
                        'mimeType' => Common::configValue('image_type')
                    ]
                ],
                ['name' => 'FileIsImage'],
                [
                    'name' => 'FileSize',
                    'options' => Common::configValue('upload_image_max')
                ]
            ],
            'filters'  => [
                [
                    'name' => 'FileRenameUpload',
                    'options' => [
                        'target' => Config::COMMON_IMAGE_PATH . 'shop_footer_image_4.png',
                        'overwrite'=>true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'shop_footer_image_4_url|shop_footer',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'type'      => 'Laminas\InputFilter\FileInput',
            'name'      => 'shop_footer_image_5|shop_footer',
            'required'  => false,
            'validators'=> [
                ['name' => 'FileUploadFile'],
                [
                    'name' => 'FileMimeType',
                    'options' => [
                        'mimeType' => Common::configValue('image_type')
                    ]
                ],
                ['name' => 'FileIsImage'],
                [
                    'name' => 'FileSize',
                    'options' => Common::configValue('upload_image_max')
                ]
            ],
            'filters'  => [
                [
                    'name' => 'FileRenameUpload',
                    'options' => [
                        'target' => Config::COMMON_IMAGE_PATH . 'shop_footer_image_5.png',
                        'overwrite'=>true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'shop_footer_image_5_url|shop_footer',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);
    }
}