<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Form;

use Admin\Data\Common;
use Admin\Data\Config;
use Laminas\Form\Form;

class UploadSetForm extends Form
{
    public function __construct($name = 'upload-set-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'post');
        $this->setAttribute('enctype', 'multipart/form-data');
        $this->setAttribute('class', 'form-horizontal');

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        /*=============================基本设置=============================*/
        $this->add([
            'type'  => 'number',
            'name'  => 'upload_image_max',
            'attributes'    => [
                'id'            => 'upload_image_max',
                'class'         => 'form-control',
                'value'         => 2000
            ]
        ]);

        $this->add([
            'type'  => 'multiCheckbox',
            'name'  => 'image_type',
            'options' => [
                'label_attributes' => [
                    'class' => 'checkbox-inline'
                ]
            ]
        ]);

        /*=============================默认图片=============================*/
        $this->add([
            'type'  => 'number',
            'name'  => 'goods_thumb_width',
            'attributes'    => [
                'id'            => 'goods_thumb_width',
                'class'         => 'form-control',
                'value'         => 500
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'goods_thumb_height',
            'attributes'    => [
                'id'            => 'goods_thumb_height',
                'class'         => 'form-control',
                'value'         => 500
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'goods_image_crop',
            'attributes'    => [
                'id'            => 'goods_image_crop',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'goods_watermark_state',
            'attributes'    => [
                'id'            => 'goods_watermark_state',
                'value'         => 0
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'goods_image_name_type',
            'attributes'    => [
                'id'            => 'goods_image_name_type',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'file',
            'name'  => 'goods_image_default',
            'attributes' => [
                'id' => 'goods_image_default'
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'brand_logo_width',
            'attributes'    => [
                'id'            => 'brand_logo_width',
                'class'         => 'form-control',
                'value'         => 160
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'brand_logo_height',
            'attributes'    => [
                'id'            => 'brand_logo_height',
                'class'         => 'form-control',
                'value'         => 80
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'brand_logo_crop',
            'attributes'    => [
                'id'            => 'brand_logo_crop',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'file',
            'name'  => 'brand_logo_default',
            'attributes' => [
                'id' => 'brand_logo_default'
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'class_image_width',
            'attributes'    => [
                'id'            => 'class_image_width',
                'class'         => 'form-control',
                'value'         => 100
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'class_image_height',
            'attributes'    => [
                'id'            => 'class_image_height',
                'class'         => 'form-control',
                'value'         => 100
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'class_image_crop',
            'attributes'    => [
                'id'            => 'class_image_crop',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'file',
            'name'  => 'class_image_default',
            'attributes' => [
                'id' => 'class_image_default'
            ]
        ]);

        /*=============================水印设置=============================*/
        $this->add([
            'type'  => 'select',
            'name'  => 'watermark_state',
            'attributes'    => [
                'id'            => 'watermark_state',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'watermark_type',
            'attributes'    => [
                'id'            => 'watermark_type',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'watermark_text',
            'attributes'    => [
                'id'            => 'watermark_text',
                'class'         => 'form-control',
                'value'         => 'DBShop'
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'watermark_text_size',
            'attributes'    => [
                'id'            => 'watermark_text_size',
                'class'         => 'form-control',
                'value'         => 2,
                'min'           => 1,
                'max'           => 5
            ]
        ]);

        $this->add([
            'type'  => 'color',
            'name'  => 'watermark_text_color',
            'attributes'    => [
                'id'            => 'watermark_text_color',
                'class'         => 'form-control',
                'readonly'      => 'readonly'
            ]
        ]);

        $this->add([
            'type'  => 'file',
            'name'  => 'watermark_image',
            'attributes'    => [
                'id'            => 'watermark_image'
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'watermark_trans',
            'attributes'    => [
                'id'            => 'watermark_trans',
                'class'         => 'form-control',
                'value'         => 30,
                'min'           => 0,
                'max'           => 100
            ]
        ]);

        $this->add([
            'type'  => 'radio',
            'name'  => 'watermark_location',
            'options' => [
                'label_attributes' => [
                    'class' => 'radio-inline'
                ],
                'disable_inarray_validator' => true
            ],
            'attributes'    => [
                'value'         => 7
            ]
        ]);

        /*=============================存储方式=============================*/
        $this->add([
            'type'  => 'select',
            'name'  => 'storage_type',
            'attributes'    => [
                'id'            => 'storage_type',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'local_pc_image_width',
            'attributes'    => [
                'id'            => 'local_pc_image_width',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'local_phone_image_width',
            'attributes'    => [
                'id'            => 'local_phone_image_width',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'qiniu_space_name',
            'attributes'    => [
                'id'            => 'qiniu_space_name',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'qiniu_ak',
            'attributes'    => [
                'id'            => 'qiniu_ak',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'qiniu_sk',
            'attributes'    => [
                'id'            => 'qiniu_sk',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'qiniu_scheme',
            'attributes'    => [
                'id'            => 'qiniu_scheme',
                'class'         => 'form-control',
                'style'         => ''
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'qiniu_domain',
            'attributes'    => [
                'id'            => 'qiniu_domain',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'qiniu_pc_image_style',
            'attributes'    => [
                'id'            => 'qiniu_pc_image_style',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'qiniu_phone_image_style',
            'attributes'    => [
                'id'            => 'qiniu_phone_image_style',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'aliyun_space_name',
            'attributes'    => [
                'id'            => 'aliyun_space_name',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'aliyun_oss_domain',
            'attributes'    => [
                'id'            => 'aliyun_oss_domain',
                'class'         => 'form-control',
                'style'         => ''
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'aliyun_ak',
            'attributes'    => [
                'id'            => 'aliyun_ak',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'aliyun_sk',
            'attributes'    => [
                'id'            => 'aliyun_sk',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'aliyun_scheme',
            'attributes'    => [
                'id'            => 'aliyun_scheme',
                'class'         => 'form-control',
                'style'         => ''
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'aliyun_domain',
            'attributes'    => [
                'id'            => 'aliyun_domain',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'aliyun_domain_type',
            'attributes'    => [
                'id'            => 'aliyun_domain_type',
                'class'         => 'form-control',
                'style'         => ''
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'aliyun_pc_image_style',
            'attributes'    => [
                'id'            => 'aliyun_pc_image_style',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'aliyun_phone_image_style',
            'attributes'    => [
                'id'            => 'aliyun_phone_image_style',
                'class'         => 'form-control'
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'upload_image_max',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'image_type',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'goods_thumb_width',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0,
                        'inclusive' => true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goods_thumb_height',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0,
                        'inclusive' => true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goods_watermark_state',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'brand_logo_width',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0,
                        'inclusive' => true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'brand_logo_height',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0,
                        'inclusive' => true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'class_image_width',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0,
                        'inclusive' => true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'class_image_height',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0,
                        'inclusive' => true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'watermark_text',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'watermark_text_size',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'Between',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 5
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'watermark_trans',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'watermark_location',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [1, 2, 3, 4, 5, 6, 7, 8, 9]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'type'      => 'Laminas\InputFilter\FileInput',
            'name'      => 'watermark_image',
            'required'  => false,
            'validators'=> [
                ['name' => 'FileUploadFile'],
                [
                    'name' => 'FileMimeType',
                    'options' => [
                        'mimeType' => Common::configValue('image_type')
                    ]
                ],
                ['name' => 'FileIsImage'],
                [
                    'name' => 'FileSize',
                    'options' => Common::configValue('upload_image_max')
                ]
            ],
            'filters'  => [
                [
                    'name' => 'FileRenameUpload',
                    'options' => [
                        'target' => Config::COMMON_IMAGE_PATH . 'shop_watermark.png',
                        'overwrite'=>true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'type'      => 'Laminas\InputFilter\FileInput',
            'name'      => 'goods_image_default',
            'required'  => false,
            'validators'=> [
                ['name' => 'FileUploadFile'],
                [
                    'name' => 'FileMimeType',
                    'options' => [
                        'mimeType' => Common::configValue('image_type')
                    ]
                ],
                ['name' => 'FileIsImage'],
                [
                    'name' => 'FileSize',
                    'options' => Common::configValue('upload_image_max')
                ]
            ],
            'filters'  => [
                [
                    'name' => 'FileRenameUpload',
                    'options' => [
                        'target' => Config::COMMON_IMAGE_PATH . 'shop_goods.png',
                        //'useUploadName'=>true,
                        //'useUploadExtension'=>true,
                        'overwrite'=>true,
                        //'randomize'=>true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'type'      => 'Laminas\InputFilter\FileInput',
            'name'      => 'brand_logo_default',
            'required'  => false,
            'validators'=> [
                ['name' => 'FileUploadFile'],
                [
                    'name' => 'FileMimeType',
                    'options' => [
                        'mimeType' => Common::configValue('image_type')
                    ]
                ],
                ['name' => 'FileIsImage'],
                [
                    'name' => 'FileSize',
                    'options' => Common::configValue('upload_image_max')
                ]
            ],
            'filters'  => [
                [
                    'name' => 'FileRenameUpload',
                    'options' => [
                        'target' => Config::COMMON_IMAGE_PATH . 'shop_brand.png',
                        //'useUploadName'=>true,
                        //'useUploadExtension'=>true,
                        'overwrite'=>true,
                        //'randomize'=>true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'type'      => 'Laminas\InputFilter\FileInput',
            'name'      => 'class_image_default',
            'required'  => false,
            'validators'=> [
                ['name' => 'FileUploadFile'],
                [
                    'name' => 'FileMimeType',
                    'options' => [
                        'mimeType' => Common::configValue('image_type')
                    ]
                ],
                ['name' => 'FileIsImage'],
                [
                    'name' => 'FileSize',
                    'options' => Common::configValue('upload_image_max')
                ]
            ],
            'filters'  => [
                [
                    'name' => 'FileRenameUpload',
                    'options' => [
                        'target' => Config::COMMON_IMAGE_PATH . 'shop_class.png',
                        //'useUploadName'=>true,
                        //'useUploadExtension'=>true,
                        'overwrite'=>true,
                        //'randomize'=>true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'local_pc_image_width',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0,
                        'inclusive' => true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'local_phone_image_width',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0,
                        'inclusive' => true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'qiniu_space_name',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'qiniu_ak',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'qiniu_sk',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'qiniu_scheme',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'qiniu_domain',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'qiniu_pc_image_style',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'qiniu_phone_image_style',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'aliyun_space_name',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'aliyun_oss_domain',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'aliyun_ak',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'aliyun_sk',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'aliyun_scheme',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'aliyun_domain',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'aliyun_domain_type',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'aliyun_pc_image_style',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'aliyun_phone_image_style',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

    }
}