<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Plugin;

use Admin\Data\Common;
use Admin\Entity\Currency;
use Admin\Entity\DeliveryIndividuation;
use Admin\Entity\PhoneAreaCode;
use Admin\Entity\System;
use Doctrine\ORM\EntityManager;
use Goods\Entity\GoodsClass;
use Laminas\Mvc\Controller\Plugin\AbstractPlugin;
use Operation\Entity\Coupon;
use Operation\Entity\DiscountRule;
use User\Entity\IntegralRule;
use User\Entity\IntegralType;
use User\Entity\UserGroup;

/**
 * 配置文件生成
 * Class CreateConfigPlugin
 * @package Admin\Plugin
 */
class CreateConfigPlugin extends AbstractPlugin
{
    private $entityManager;

    public function __construct(EntityManager $entityManager)
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 系统设置生成配置文件
     */
    public function createSystem()
    {
        $shopConfig = $this->entityManager->getRepository(System::class)->findBaseSystem();
        $configArray = [];
        foreach ($shopConfig as $configValue) {
            $configArray[$configValue->getSysType()][$configValue->getSysName()] = $configValue->getSysBody();
        }
        Common::writeConfigFile('config', $configArray);
    }

    /**
     * 国际电话区号生成配置文件
     */
    public function createPhoneArea()
    {
        $phoneArea  = $this->entityManager->getRepository(PhoneAreaCode::class)->findBy(['areaState' => 1], ['areaSort' => 'ASC']);
        $areaArray  = [];
        $default    = [];
        foreach ($phoneArea as $areaValue) {
            if($areaValue->getAreaId() == 1) {
                $default = $areaValue->valuesArray();
                //$default['areaName'] = '(+'.$areaValue->getAreaPhoneCode().')'.$areaValue->getAreaName();
            }
            $areaArray[$areaValue->getAreaCode()] = $areaValue->valuesArray();
            //$areaArray[$areaValue->getAreaCode()]['areaName'] = '(+'.$areaValue->getAreaPhoneCode().')'.$areaValue->getAreaName();
        }
        Common::writeConfigFile('phoneArea', ['default' => $default, 'list' => $areaArray]);
    }

    /**
     * 图片附件生成配置文件
     */
    public function createUpload()
    {
        $uploadConfig       = $this->entityManager->getRepository(System::class)->findBy(['sysType' => 'upload']);
        $uploadConfigArray  = [];
        if($uploadConfig) {
            foreach ($uploadConfig as $value) {
                if($value->getSysName() == 'image_type') $uploadConfigArray[$value->getSysName()] = explode(',', str_replace('|', ',', $value->getSysBody()));
                else $uploadConfigArray[$value->getSysName()] = $value->getSysBody();
            }
        }
        Common::writeConfigFile('upload', $uploadConfigArray);
    }

    /**
     * 商家配送设置配置文件
     * @param $data
     */
    public function createShopDelivery($data)
    {
        $individuation  = $this->entityManager->getRepository(DeliveryIndividuation::class)->findBy([]);
        $indivArray     = [];
        if($individuation != null) foreach ($individuation as $value) {
            $indivArray[] = ['area' => unserialize($value->getDeliveryArea()), 'price' => $value->getDeliveryPrice()];
        }
        $data['G'] = $indivArray;
        Common::writeConfigFile('delivery', $data);
    }

    /**
     * 客户设置生成配置文件
     */
    public function createCustomer()
    {
        $customerConfig       = $this->entityManager->getRepository(System::class)->findBy(['sysType' => 'customer']);
        $customerConfigArray  = [];
        $loginTypeArray       = Common::otherLoginTypeArray();
        $enableLogin = [];
        if($customerConfig) {
            foreach ($customerConfig as $value) {
                $customerConfigArray[$value->getSysName()] = $value->getSysName() == 'login_item' ? unserialize($value->getSysBody()) : $value->getSysBody();
                //判断开启了哪些登录
                if (isset($loginTypeArray[$value->getSysName()]) && $value->getSysBody() == 1) $enableLogin[] = $loginTypeArray[$value->getSysName()];
            }
        }
        $customerConfigArray['enableLogin'] = $enableLogin;

        Common::writeConfigFile('customer', $customerConfigArray);
    }

    /**
     * 货币生成配置文件
     */
    public function createCurrency()
    {
        $currencyList = $this->entityManager->getRepository(Currency::class)->findBy([], ['currencyType' => 'DESC']);
        $currencyArray= [];
        foreach ($currencyList as $cValue) {
            if($cValue->getCurrencyType() == 1) {
                $currencyArray['default'] = [
                    'id'        => $cValue->getCurrencyId(),
                    'name'      => $cValue->getCurrencyName(),
                    'code'      => $cValue->getCurrencyCode(),
                    'symbol'    => $cValue->getCurrencySymbol(),
                    'decimal'   => $cValue->getCurrencyDecimal(),
                    'rate'      => $cValue->getCurrencyRate(),
                    'state'     => $cValue->getCurrencyState()
                ];
            }

            $currencyArray[$cValue->getCurrencyCode()] = [
                'id'        => $cValue->getCurrencyId(),
                'name'      => $cValue->getCurrencyName(),
                'code'      => $cValue->getCurrencyCode(),
                'symbol'    => $cValue->getCurrencySymbol(),
                'decimal'   => $cValue->getCurrencyDecimal(),
                'rate'      => $cValue->getCurrencyRate(),
                'state'     => $cValue->getCurrencyState()
            ];
        }
        Common::writeConfigFile('currency', $currencyArray);
    }

    /**
     * 积分类型生成配置文件
     */
    public function createIntegral()
    {
        $integralConfig       = $this->entityManager->getRepository(IntegralType::class)->findBy([], ['integralTypeId' => 'ASC']);
        $integralConfigArray  = [];
        if($integralConfig) {
            foreach ($integralConfig as $value) {
                $integralConfigArray[$value->getIntegralTypeMark()] = $value->valuesArray();
            }
        }
        Common::writeConfigFile('integral', $integralConfigArray);
    }

    /**
     * 积分规则生成配置文件
     */
    public function createIntegralRule()
    {
        $integralRuleList = $this->entityManager->getRepository(IntegralRule::class)->findBy(['integralRuleState' => 1], ['integralRuleId' => 'DESC']);
        $integralRuleArray= [];
        if ($integralRuleList) {
            foreach ($integralRuleList as $value) {
                $ruleArray = $value->valuesArray();
                $ruleArray['integralRuleBody']      = unserialize($value->getIntegralRuleBody());
                $ruleArray['integralRuleUserBody']  = unserialize($value->getIntegralRuleUserBody());
                $ruleArray['integralRuleGoodsBody'] = unserialize($value->getIntegralRuleGoodsBody());

                $integralRuleArray[$value->getIntegralRuleType()][$value->getIntegralRuleId()] = $ruleArray;

            }
        }

        Common::writeConfigFile('integralRule', $integralRuleArray);
    }

    /**
     * 促销规则生成配置文件
     */
    public function createDiscountRule()
    {
        $discountRuleList = $this->entityManager->getRepository(DiscountRule::class)->findBy(['discountState' => 1], ['discountRuleId' => 'DESC']);
        $discountRuleArray= [];
        if ($discountRuleList) {
            foreach ($discountRuleList as $value) {
                $ruleArray = $value->valuesArray();
                $ruleArray['discountUserGroup']  = unserialize($value->getDiscountUserGroup());
                $ruleArray['discountGoodsBody'] = unserialize($value->getDiscountGoodsBody());

                $discountRuleArray[$value->getDiscountRuleId()] = $ruleArray;
            }
        }

        Common::writeConfigFile('discountRule', $discountRuleArray);
    }

    /**
     * 创建优惠券
     */
    public function createCoupon()
    {
        $couponList = $this->entityManager->getRepository(Coupon::class)->findBy(['couponState' => 1], ['couponId' => 'DESC']);
        $couponArray= [];
        if ($couponList) {
            foreach ($couponList as $value) {
                $array = $value->valuesArray();
                $array['userGroup']  = unserialize($value->getGetUserGroup());
                $array['goodsBody'] = unserialize($value->getGetGoodsBody());

                $couponArray[$value->getCouponId()] = $array;
            }
        }

        Common::writeConfigFile('coupon', $couponArray);
    }

    /**
     * 客户组信息
     */
    public function createUserGroup()
    {
        $userGroup      = $this->entityManager->getRepository(UserGroup::class)->findBy([], ['integralStart' => 'ASC']);
        $userGroupArray = [];
        if ($userGroup) foreach ($userGroup as $groupValue) {
            $userGroupArray[$groupValue->getUserGroupId()] = $groupValue->valuesArray();
        }

        Common::writeConfigFile('userGroup', $userGroupArray);
    }
}