<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Plugin;

use Laminas\Filter\HtmlEntities;
use Laminas\Mvc\Controller\Plugin\AbstractPlugin;

class DeliveryPlugin extends AbstractPlugin
{
    public function __construct()
    {
    }

    /**
     * 对配送公式进行解析，并计算结果
     * @param $express
     * @param $weight
     * @param $totalMoney
     * @param int $defaultCost
     * @return int|string
     */
    public function calculateCost ($express, $weight, $totalMoney, $defaultCost = 0)
    {
        $express = strip_tags(str_replace([' ', ' ', '`'], '', $express));
        if(!preg_match("/^[WwPp\d\+\.\-\*\/\(\)\[\]\{\}]*$/i",$express))
        {
            return $defaultCost;
        }

        $filter = new HtmlEntities();
        $express    = $filter->filter($express);
        $weight     = (int) $weight;
        $totalMoney = floatval($totalMoney);

        if ($str = trim($express)) {
            $costVal = 0;
            $str = str_replace("（", "(", $str);
            $str = str_replace("）", ")", $str);
            $str = str_replace("[", "\$this->getCeil(", $str);
            $str = str_replace("]", ")", $str);
            $str = str_replace("{", "\$this->getValue(", $str);
            $str = str_replace("}", ")", $str);
            $str = str_replace("w", $weight, $str);
            $str = str_replace("W", $weight, $str);
            $str = str_replace("p", $totalMoney, $str);
            $str = str_replace("P", $totalMoney, $str);
            @eval("\$costVal = {$str};");
            if ($costVal === 'failed') {
                return $defaultCost;
            }
            if (!is_numeric($costVal)) return 0;
            return $costVal;
        } else {
            return $defaultCost;
        }
    }

    /**
     * 值计算，对{}中的公式进行计算
     * @param string $expressStr
     * @return number
     */
    private function getValue ($expressStr)
    {
        if ($expressStr !== '') {
            $expressNum = 0;
            @eval("\$expressNum={$expressStr};");
            if ($expressNum > 0) {
                return 1;
            } else {
                if ($expressNum == 0) {
                    return 0.5;
                }
            }
        }
        return 0;
    }

    /**
     * 进一操作
     * @param string $expressStr
     * @return number
     */
    public function getCeil ($expressStr)
    {
        if ($expressStr = trim($expressStr)) {
            $expressNum = 0;
            @eval(" \$expressNum={$expressStr};");
            if ($expressNum > 0) {
                return ceil($expressNum);
            }
        }
        return 0;
    }
}