<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Plugin\Factory;

use Admin\Data\Config;
use Admin\Plugin\AdminCommonPlugin;
use Admin\Service\OperLogManager;
use Interop\Container\ContainerInterface;
use Laminas\Mvc\I18n\Translator;
use Laminas\ServiceManager\Factory\FactoryInterface;

class AdminCommonPluginFactory implements FactoryInterface
{
    public function __invoke(ContainerInterface $container, $requestedName, array $options = null)
    {
        $entityManager = $container->get(Config::SHOP_DATABASE_MANAGER_READ);
        $translator    = $container->get(Translator::class);
        $operLogManager= $container->get(OperLogManager::class);

        return new AdminCommonPlugin($entityManager, $translator, $operLogManager);
    }
}