<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Repository;

use Admin\Repository\QuerySearch\AdminUserSearch;
use Doctrine\ORM\EntityRepository;
use Admin\Entity\AdminUser;

class AdminUserRepository extends EntityRepository
{
    /**
     * 获取管理员列表sql
     * @param array $search
     * @return \Doctrine\ORM\Query
     */
    public function findAllAdmin(array $search = [])
    {
        $query = $this->getEntityManager()->createQueryBuilder()
            ->select('a', 'g')
            ->from(AdminUser::class, 'a')
            ->join('a.group', 'g')
            ->orderBy('a.adminId', 'ASC');

        //检索
        $query = AdminUserSearch::querySearchData($search, $query);

        return $query->getQuery();
    }
}