<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Repository;

use Admin\Entity\OperLog;
use Admin\Repository\QuerySearch\OperLogSearch;
use Doctrine\ORM\EntityRepository;

class OperLogRepository extends EntityRepository
{
    /**
     * 获取操作日志列表sql
     * @param array $search
     * @return \Doctrine\ORM\Query
     */
    public function findOperLogAll(array $search = [])
    {
        $query = $this->getEntityManager()->createQueryBuilder()
            ->select('o')
            ->from(OperLog::class, 'o')
            ->orderBy('o.logId', 'DESC');

        $query = OperLogSearch::querySearchData($search, $query);

        return $query->getQuery();
    }
}