<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Service;

use Admin\Entity\AdminUser;
use Admin\Entity\AdminUserGroup;
use Doctrine\ORM\EntityManager;

class AdminUserGroupManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加管理员组
     * @param array $data
     * @return AdminUserGroup
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addAdminGroup(array $data)
    {
        $adminGroup = new AdminUserGroup();
        $adminGroup->valuesSet($data);
        if(!empty($data['adminGroupPermission'])) {
            $adminGroup->setAdminGroupPurview(implode(',', $data['adminGroupPermission']));
        }

        $this->entityManager->persist($adminGroup);
        $this->entityManager->flush();

        return $adminGroup;
    }

    /**
     * 更新管理员组
     * @param AdminUserGroup $adminGroup
     * @param $data
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function updateAdminGroup(AdminUserGroup $adminGroup, $data)
    {
        $adminGroup->valuesSet($data);
        if(!empty($data['adminGroupPermission'])) {
            $adminGroup->setAdminGroupPurview(implode(',', $data['adminGroupPermission']));
        } else $adminGroup->setAdminGroupPurview('');

        $this->entityManager->flush();

        return true;
    }

    /**
     * 删除管理员组
     * @param $adminGroup
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deleteAdminGroup($adminGroup)
    {
        $adminUser = $this->entityManager->getRepository(AdminUser::class)->findOneBy(['adminGroupId'=>$adminGroup->getAdminGroupId()]);
        if($adminUser == null) {
            $this->entityManager->remove($adminGroup);
            $this->entityManager->flush();
            return true;
        }
        return false;
    }
}