<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Service;

use Admin\Data\Common;
use Doctrine\ORM\EntityManager;
use Laminas\Authentication\Adapter\AdapterInterface;
use Laminas\Authentication\Result;
use Admin\Entity\AdminUser;

class AuthAdapter implements AdapterInterface
{
    private $name;
    private $password;
    private $adminState;
    private $user;
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }
    

    public function setName($name)
    {
        $this->name = $name;
    }

    public function setPassword($password) 
    {
        $this->password = (string)$password;        
    }

    public function setAdminState($adminState)
    {
        $this->adminState = $adminState;
    }
    
    /**
     * Performs an authentication attempt.
     */
    public function authenticate()
    {
        $this->user = $this->entityManager->getRepository(AdminUser::class)
            ->findOneBy([
                'adminName' => $this->name,
                'adminState' => $this->adminState
            ]);

        if ($this->user == null) {
            return new Result(
                Result::FAILURE_IDENTITY_NOT_FOUND,
                null,
                ['Invalid credentials.']);
        } elseif (Common::verifyAdminPassword($this->password, $this->user->getAdminPassword())) {
            return new Result(
                Result::SUCCESS,
                $this->user->getAdminId(),
                ['Authenticated successfully.']);
        }

        return new Result(
            Result::FAILURE_CREDENTIAL_INVALID,
            null,
            ['Invalid credentials.']);
    }

    /**
     * 检查admin
     * @param $adminId
     * @return AdminUser|false|object
     */
    public function checkAdmin($adminId)
    {
        $admin = $this->entityManager->getRepository(AdminUser::class)->findOneBy(['adminId' => $adminId, 'adminState' => 1]);
        if($admin) return $admin;
        return false;
    }

    public function getUser()
    {
        return $this->user;
    }
}


