<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Service\Common\Express;

class Kdniao
{
    private $expressQueryUrl = 'http://api.kdniao.com/Ebusiness/EbusinessOrderHandle.aspx';
    private $expressConfig;

    public function setExpressConfig(array $expressConfig)
    {
        $this->expressConfig = $expressConfig;
    }

    /**
     * @param array $data
     * @param $unifiedDelivery
     * @return array
     */
    public function ExpressQuery(array $data, $unifiedDelivery)
    {
        $requestData    = "{'OrderCode':'','ShipperCode':'{$data['code']}','LogisticCode':'{$data['number']}'}";
        $dataArray      = [
            'EBusinessID'   => $this->expressConfig['deliveryApiSecret'],
            'RequestType'   => '1002',
            'RequestData'   => urlencode($requestData),
            'DataType'      => '2',
            'DataSign'      => base64_encode(md5($requestData.$this->expressConfig['deliveryApiKey']))
        ];
        $postData = http_build_query($dataArray);

        $ch = curl_init();
        $header[] = 'Content-Type:application/x-www-form-urlencoded;charset=utf-8';
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_URL, $this->expressQueryUrl);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
        curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
        curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_0);
        curl_setopt($ch, CURLOPT_ENCODING, 'gzip');
        $result = curl_exec($ch);
        $result = json_decode($result, true);

        if(isset($result['Success']) && $result['Success'] === false && !empty($result['Reason'])){
            return ['state' => false, 'content' => $result['Reason']];
        }

        if(!isset($result['Traces']) || !is_array($result['Traces'])){
            return ['state' => false, 'content' => '暂时查不到有效物流轨迹'];
        }

        $tracesArray = array_reverse($result['Traces']);
        //$contentArray= [];
        $content = '';
        if (is_array($tracesArray) && !empty($tracesArray)) {
            $content = '<table style="width: 98%; margin-left: 5px;">';
            $content .= '<tr><td width="27%" style="padding-left: 8px;background: #64AADB;border: #75C2EF 1px solid;color: #FFFFFF;font-weight: bold;">时间</td>';
            $content .= '<td width="73%" style="padding-left: 8px;background: #64AADB;border: #75C2EF 1px solid;color: #FFFFFF;font-weight: bold;">地点和跟踪进度</td></tr>';
            foreach ($tracesArray as $key => $value) {
                /*$contentArray[] = [
                    'content'   => $value['AcceptStation'],
                    'time'      => $value['AcceptTime']
                ];*/
                $content .= '<tr>';
                $content .= '<td style="padding-left: 8px;padding-bottom: 5px;padding-top: 5px;border: 1px solid #DDDDDD;'.($key == 0 ? 'color:#FF6600;' : '').'">';
                $content .= $value['AcceptTime'];
                $content .= '</td>';
                $content .= '<td style="padding-left: 8px;padding-bottom: 5px;padding-top: 5px;border: 1px solid #DDDDDD;'.($key == 0 ? 'color:#FF6600;' : '').'">';
                $content .= $value['AcceptStation'];
                $content .= '</td></tr>';
            }
            $content .= '</table>';
        }

        return ['state' => true, 'content' => $content];
    }
}