<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Service\Common\Express;

class Kuaidi100
{
    private $expressQueryUrl = 'http://poll.kuaidi100.com/poll/query.do';
    private $expressConfig;

    public function setExpressConfig(array $expressConfig)
    {
        $this->expressConfig = $expressConfig;
    }

    /**
     * 快递实时查询
     * @param array $data
     * @param $unifiedDelivery
     * @return array
     */
    public function ExpressQuery(array $data, $unifiedDelivery)
    {
        $postData = [
            'customer'  => $this->expressConfig['deliveryApiSecret'],
            'param'     => '{"com":"'.$data['code'].'","num":"'.$data['number'].'"}'
        ];
        $postData['sign'] = strtoupper(md5($postData["param"].$this->expressConfig['deliveryApiKey'].$postData["customer"]));

        $str = '';
        foreach ($postData as $key => $val) {
            $str .= "$key=".urlencode($val).'&';
        }
        $postData = rtrim($str, '&');

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_URL, $this->expressQueryUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
        $result = curl_exec($ch);
        $result = str_replace("\&quot;",'"',$result );
        $result = json_decode($result,true);

        if (!isset($result['status'])) return ['state' => false, 'content' => '设置不正确'];
        if ($result['status'] != 200) return ['state' => false, 'content' => $result['message']];

        //$contentArray= [];
        $content = '';
        if (is_array($result['data']) && !empty($result['data'])) {
            $content = '<table style="width: 98%; margin-left: 5px;">';
            $content .= '<tr><td width="27%" style="padding-left: 8px;background: #64AADB;border: #75C2EF 1px solid;color: #FFFFFF;font-weight: bold;">时间</td>';
            $content .= '<td width="73%" style="padding-left: 8px;background: #64AADB;border: #75C2EF 1px solid;color: #FFFFFF;font-weight: bold;">地点和跟踪进度</td></tr>';
            foreach ($result['data'] as $dKey => $dVal) {
                /*$contentArray[] = [
                    'content'   => $dVal['context'],
                    'time'      => $dVal['ftime']
                ];*/
                $content .= '<tr>';
                $content .= '<td style="padding-left: 8px;padding-bottom: 5px;padding-top: 5px;border: 1px solid #DDDDDD;'.($dKey == 0 ? 'color:#FF6600;' : '').'">';
                $content .= $dVal['ftime'];
                $content .= '</td>';
                $content .= '<td style="padding-left: 8px;padding-bottom: 5px;padding-top: 5px;border: 1px solid #DDDDDD;'.($dKey == 0 ? 'color:#FF6600;' : '').'">';
                $content .= $dVal['context'];
                $content .= '</td></tr>';
            }
            $content .= '</table>';
        }

        return ['state' => true, 'content' => $content];
    }
}