<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Service\Common\Express;

use Laminas\Config\Factory;
use Laminas\Db\Adapter\Adapter;
use Laminas\Db\TableGateway\TableGateway;
use Laminas\Json\Json;

class LongExpressPush
{
    private $expressConfig;
    private $db;

    public function __construct()
    {
        $dbConfig = Factory::fromFile('data/shopDatabase.php');
        $this->db = new Adapter([
            'driver'    => 'Pdo',
            'dsn'       => 'mysql:dbname='.$dbConfig['dbname'].';port='.$dbConfig['port'].';host='.$dbConfig['host'].';charset=utf8',
            'username'  => $dbConfig['user'],
            'password'  => $dbConfig['password'],
            'driver_options' => [
                \PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES 'UTF8'",
                \PDO::MYSQL_ATTR_INIT_COMMAND => "SET sql_mode=(SELECT REPLACE(@@sql_mode,'ONLY_FULL_GROUP_BY',''))"
            ]
        ]);
    }

    public function setExpressConfig(array $expressConfig)
    {
        //$this->expressConfig = $expressConfig;
    }

    public function ExpressQuery(array $data, $unifiedDelivery)
    {
        $receiveTable = new TableGateway('dbshop_express_push_receive', $this->db);
        $rowSet = $receiveTable->select(['com_code' => $data['code'], 'com_number' => $data['number']]);
        $receiveResult= $rowSet->current();
        if (!$receiveResult) return ['state' => false, 'content' => '暂无配送轨迹信息'];

        $bodyObject = Json::decode($receiveResult->receive_body);
        if ($bodyObject->returnCode != 200) return ['state' => false, 'content' => $bodyObject->message];

        $param  = $bodyObject->param;
        $content = '';
        if (isset($param->lastResult->data) && !empty($param->lastResult->data)) {
            $content = '<table style="width: 98%; margin-left: 5px;">';
            $content .= '<tr><td width="27%" style="padding-left: 8px;background: #64AADB;border: #75C2EF 1px solid;color: #FFFFFF;font-weight: bold;">时间</td>';
            $content .= '<td width="73%" style="padding-left: 8px;background: #64AADB;border: #75C2EF 1px solid;color: #FFFFFF;font-weight: bold;">地点和跟踪进度</td></tr>';
            foreach ($param->lastResult->data  as $dKey => $dVal) {

                $content .= '<tr>';
                $content .= '<td style="padding-left: 8px;padding-bottom: 5px;padding-top: 5px;border: 1px solid #DDDDDD;'.($dKey == 0 ? 'color:#FF6600;' : '').'">';
                $content .= $dVal->ftime;
                $content .= '</td>';
                $content .= '<td style="padding-left: 8px;padding-bottom: 5px;padding-top: 5px;border: 1px solid #DDDDDD;'.($dKey == 0 ? 'color:#FF6600;' : '').'">';
                $content .= $dVal->context;
                $content .= '</td></tr>';
            }
            $content .= '</table>';
        }
        return ['state' => true, 'content' => $content];
    }
}