<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Service\Common;

use Admin\Data\Common;

/**
 * 快递接口
 * Class ExpressQuery
 * @package Admin\Service\Common
 */
class ExpressApi
{
    /**
     * 快递查询
     * @param $expressCode
     * @param $expressNumber
     * @param bool $unifiedDelivery 是否为统一发货
     * @return false
     */
    public static function expressQuery($expressCode, $expressNumber, $unifiedDelivery = true)
    {
        $expressConfig = Common::readConfigFile('delivery');
        if ($expressConfig['deliveryApiState'] != 1 || empty($expressConfig['deliveryApiType'])) return false;

        $expressObject  = 'Admin\\Service\\Common\\Express\\' . ucfirst($expressConfig['deliveryApiType']);
        $express        = new $expressObject;
        $express->setExpressConfig($expressConfig);

        return $express->ExpressQuery(['code' => $expressCode, 'number' => $expressNumber], $unifiedDelivery);
    }
}