<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Service\Common;

use Admin\Data\Common;

class PhoneMessage
{
    /**
     * 发送短信
     * @param $data
     * @return bool
     */
    public static function sendSms($data)
    {
        $smsConfig = Common::configValue('sms', 'config');
        if($smsConfig['sms_state'] != 1 || empty($smsConfig['sms_service_provider'])) return false;

        $smsObject = 'Admin\\Service\\Common\\PhoneSms\\' . ucfirst($smsConfig['sms_service_provider']);
        $phoneSms = new $smsObject;
        $phoneSms->setSmsConfig($smsConfig);

        $phoneMessage = Common::readConfigFile('phoneMessage');
        if(empty($phoneMessage[$smsConfig['sms_service_provider']][$data['templateCode'].'SmsTemplateId'])) return false;
        $templateCode = $phoneMessage[$smsConfig['sms_service_provider']][$data['templateCode'].'SmsTemplateId'];

        $phoneNumberArray[] = ['number' => $data['phone'], 'areaCode' => $data['phoneAreaCode']];

        return $phoneSms->sendPhoneSms(['phone' => $phoneNumberArray, 'templateCode' => $templateCode, 'contentArray' => $data['contentArray']]);
    }

    /**
     * 发送订单短信通知
     * @param $data
     * @return bool
     */
    public static function sendOrderSms($data)
    {
        $smsConfig = Common::configValue('sms', 'config');
        if($smsConfig['sms_state'] != 1 || empty($smsConfig['sms_service_provider'])) return false;

        $smsObject = 'Admin\\Service\\Common\\PhoneSms\\' . ucfirst($smsConfig['sms_service_provider']);
        $phoneSms = new $smsObject;
        $phoneSms->setSmsConfig($smsConfig);

        $phoneMessage = Common::readConfigFile('phoneMessage');
        if(empty($phoneMessage[$smsConfig['sms_service_provider']][$data['templateCode'].'SmsTemplateId'])) return false;
        $templateCode = $phoneMessage[$smsConfig['sms_service_provider']][$data['templateCode'].'SmsTemplateId'];

        $phoneNumberArray = [];
        if (!empty($data['phone'])) $phoneNumberArray[] = ['number' => $data['phone'], 'areaCode' => $data['phoneAreaCode']];
        if(!empty($phoneMessage['adminPhone']) && !empty($phoneMessage['adminPhoneSend']) && in_array($data['templateCode'], $phoneMessage['adminPhoneSend'])) {
            $phoneNumberArray[] = ['number' => $phoneMessage['adminPhone'], 'areaCode' => $phoneMessage['areaCode']];
        }
        if (empty($phoneNumberArray)) return false;

        return $phoneSms->sendOrderPhoneSms(['phone' => $phoneNumberArray, 'templateCode' => $templateCode, 'contentArray' => $data['contentArray']]);
    }
}