<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Service\Common\PhoneSms;

use Admin\Data\Common;
use Laminas\Json\Json;
use TencentCloud\Common\Credential;
use TencentCloud\Common\Exception\TencentCloudSDKException;
use TencentCloud\Common\Profile\ClientProfile;
use TencentCloud\Common\Profile\HttpProfile;
use TencentCloud\Sms\V20190711\Models\SendSmsRequest;
use TencentCloud\Sms\V20190711\SmsClient;

class TencentSms
{
    private $sendSms;
    private $sendSmsQuery;

    public function setSmsConfig($smsConfig)
    {
        $cred = new Credential($smsConfig['sms_id'], $smsConfig['sms_secret']);
        $httpProfile = new HttpProfile();
        $httpProfile->setEndpoint("sms.tencentcloudapi.com");

        $clientProfile = new ClientProfile();
        $clientProfile->setSignMethod('TC3-HMAC-SHA256');
        $clientProfile->setHttpProfile($httpProfile);
        $this->sendSmsQuery = new SmsClient($cred, "ap-beijing", $clientProfile);

        $this->sendSms = new SendSmsRequest();
        $this->sendSms->SmsSdkAppid= $smsConfig['sms_sdk_id'];
        $this->sendSms->Sign       = $smsConfig['sms_sign_name'];
    }

    /**
     * 发送短信
     * @param array $data
     * @return bool
     */
    public function sendPhoneSms(array $data)
    {
        try {
            $this->sendSms->fromJsonString(Json::encode(['PhoneNumberSet' => $this->getPhoneNumbers($data['phone']), 'TemplateID' => $data['templateCode'], 'TemplateParamSet' => $this->createSmsContent($data['contentArray'])]));
            return $this->sendSmsQuery->SendSms($this->sendSms);
        } catch (TencentCloudSDKException $e) {
            echo $e;
        }
        return false;
    }

    /**
     * 发送订单短信
     * @param array $data
     * @return bool
     */
    public function sendOrderPhoneSms(array $data)
    {
        try {
            $this->sendSms->fromJsonString(Json::encode(['PhoneNumberSet' => $this->getPhoneNumbers($data['phone']), 'TemplateID' => $data['templateCode'], 'TemplateParamSet' => $this->createOrderSmsContent($data['contentArray'])]));
            return $this->sendSmsQuery->SendSms($this->sendSms);
        } catch (TencentCloudSDKException $e) {
            echo $e;
        }
        return false;
    }

    /**
     * 获取发送电话号码
     * @param $phoneData
     * @return array
     */
    private function getPhoneNumbers($phoneData)
    {
        $phoneArea      = Common::configValue('list', 'phoneArea');
        $phoneNumbers   = [];
        foreach ($phoneData as $value) {
            $phoneNumbers[] = '+'.$phoneArea[$value['areaCode']]['areaPhoneCode'].$value['number'];
        }

        return $phoneNumbers;
    }

    /**
     * 对短信内容进行解析
     * @param $data
     * @return array|string[]
     */
    private function createSmsContent($data)
    {
        $contentArray = [
            $data['phoneCaptcha'] ?? '',//手机验证码
        ];

        return array_filter($contentArray);
    }

    /**
     * 对订单提醒的短信内容进行解析
     * @param $data
     * @return array|string[]
     */
    private function createOrderSmsContent($data)
    {
        $contentArray = [
            $data['buyName'] ?? '',    //买家名称,
            $data['orderSn'] ?? '',    //订单编号
            $data['orderTotal'] ?? '', //订单金额
            $data['deliveryName'] ?? '',   //快递名称
            $data['expressNumber'] ?? '',  //快递单号
        ];

        return array_filter($contentArray);

    }
}