<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Service;

use Admin\Entity\Currency;
use Doctrine\ORM\EntityManager;

class CurrencyManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加货币信息
     * @param array $data
     * @return Currency
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addCurrency(array $data)
    {
        $currency = new Currency();
        $currency->valuesSet($data);
        $currency->setCurrencyDecimal(2);
        $currency->setCurrencyType(0);

        $this->entityManager->persist($currency);
        $this->entityManager->flush();

        return $currency;
    }

    /**
     * 编辑货币信息
     * @param array $data
     * @param Currency $currency
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editCurrency(array $data, Currency $currency)
    {
        unset($data['currencyId'], $data['currencyDecimal']);
        if ($currency->getCurrencyId() == 1) unset($data['currencyRate'], $data['currencyState']);

        $currency->valuesSet($data);
        $this->entityManager->flush();

        return true;
    }

    /**
     * 删除货币信息
     * @param Currency $currency
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deleteCurrency(Currency $currency)
    {
        $this->entityManager->remove($currency);
        $this->entityManager->flush();

        return true;
    }
}