<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Service;

use Admin\Entity\DeliveryIndividuation;
use Doctrine\ORM\EntityManager;

class DeliveryIndividuationManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加个性地区
     * @param array $data
     * @return DeliveryIndividuation
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addDeliveryIndividuation(array $data)
    {
        $individuation = new DeliveryIndividuation();
        $individuation->setDeliveryPrice($data['deliveryPrice']);
        $individuation->setDeliveryArea(serialize($data['deliveryArea']));

        $this->entityManager->persist($individuation);
        $this->entityManager->flush();
        return $individuation;
    }

    /**
     * 编辑更新个性地区
     * @param array $data
     * @param DeliveryIndividuation $deliveryIndividuation
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editDeliveryIndividuation(array $data, DeliveryIndividuation $deliveryIndividuation)
    {
        $deliveryIndividuation->valuesSet($data);
        $deliveryIndividuation->setDeliveryArea(serialize($data['deliveryArea']));

        $this->entityManager->flush();

        return true;
    }

    /**
     * 删除个性地区
     * @param DeliveryIndividuation $deliveryIndividuation
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deleteDeliveryIndividuation(DeliveryIndividuation $deliveryIndividuation)
    {
        $this->entityManager->remove($deliveryIndividuation);
        $this->entityManager->flush();

        return true;
    }
}