<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Service;

use Admin\Entity\Delivery;
use Doctrine\ORM\EntityManager;

class DeliveryManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加配送方式
     * @param array $data
     * @return Delivery
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addDelivery(array $data)
    {
        $delivery = new Delivery();
        $delivery->valuesSet($data);

        $this->entityManager->persist($delivery);
        $this->entityManager->flush();

        return $delivery;
    }

    /**
     * 编辑配送方式
     * @param array $data
     * @param Delivery $delivery
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editDelivery(array $data, Delivery $delivery)
    {
        unset($data['deliveryId']);
        $delivery->valuesSet($data);

        $this->entityManager->flush();
        return true;
    }

    /**
     * 删除配送方式
     * @param Delivery $delivery
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deleteDelivery(Delivery $delivery)
    {
        $this->entityManager->remove($delivery);
        $this->entityManager->flush();

        return true;
    }
}