<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Service;

use Admin\Entity\ExpressPushReceive;
use Doctrine\ORM\EntityManager;

class ExpressPushReceiveManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加轨迹信息
     * @param array $data
     * @return ExpressPushReceive
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addExpressPushReceive(array $data)
    {
        $pushReceive = new ExpressPushReceive();
        $pushReceive->valuesSet($data);

        $this->entityManager->persist($pushReceive);
        $this->entityManager->flush();

        return $pushReceive;
    }

    /**
     * 编辑轨迹信息
     * @param array $data
     * @param ExpressPushReceive $expressPushReceive
     * @return ExpressPushReceive
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editExpressPushReceive(array $data, ExpressPushReceive $expressPushReceive)
    {
        $expressPushReceive->valuesSet($data);
        $this->entityManager->flush();

        return $expressPushReceive;
    }

    /**
     * 删除轨迹信息
     * @param ExpressPushReceive $expressPushReceive
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deleteExpressPushReceive(ExpressPushReceive $expressPushReceive)
    {
        $this->entityManager->remove($expressPushReceive);
        $this->entityManager->flush();

        return true;
    }
}