<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Service\Payment;


use Admin\Data\Common;
use Laminas\Config\Writer\PhpArray;

class BalancePayService
{
    private $config             = [];
    private $balancePayConfig   = [];

    public function __construct()
    {
        if(!$this->config) {
            $this->config = Common::getPaymentConfig('balancePay');
        }

        $this->balancePayConfig = [];
    }

    public function savePaymentConfig(array $data, $paymentConfig, $configFile)
    {
        $configArray = PaymentForm::setFormValue($paymentConfig, $data);

        $write = new PhpArray();
        $write->setUseBracketArraySyntax(true);
        $write->toFile($configFile, $configArray);

        Common::opcacheInvalidate($configFile);

        return $configArray;
    }

    public function getFormInput($paymentConfig)
    {
        return PaymentForm::createFormInput($paymentConfig);
    }

    /**
     * 支付
     * @param array $data
     */
    public function orderPaymentTo(array $data)
    {
        header("Location: ".$data['returnUrl']);
        exit();
    }

    /**
     * 发货处理
     * @param array $data
     */
    public function orderToSend(array $data)
    {

    }

    /**
     * 支付返回
     * @param $orderInfo
     * @return array|bool[]
     */
    public function orderPaymentReturn($orderInfo)
    {
        if($orderInfo->getOrderStatus() >= Common::orderStatusCode('WAIT_GOODS_ARRIVE')) {
            return ['paymentStatus' => true, 'orderAmount' => $orderInfo->getOrderAmount()];
        }
        return ['paymentStatus' => false];
    }
}