<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Service\Payment;


use Admin\Data\Common;
use Laminas\Config\Writer\PhpArray;

class CashOnDeliveryService
{
    private $config = [];
    private $cashOnDeliveryConfig = [];

    public function __construct()
    {
        if(!$this->config) {
            $this->config = Common::getPaymentConfig('cashOnDelivery');
        }

        $this->cashOnDeliveryConfig = [];
    }

    public function savePaymentConfig(array $data, $paymentConfig, $configFile)
    {
        $configArray = PaymentForm::setFormValue($paymentConfig, $data);

        $write = new PhpArray();
        $write->setUseBracketArraySyntax(true);
        $write->toFile($configFile, $configArray);

        Common::opcacheInvalidate($configFile);
    }

    public function getFormInput($paymentConfig)
    {
        return PaymentForm::createFormInput($paymentConfig);
    }

    public function orderPaymentTo(array $data)
    {
        header("Location: ".$data['returnUrl']);
        exit();
    }

    public function orderToSend(array $data)
    {

    }

    public function orderPaymentReturn()
    {

    }
}