<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Service\Payment;


use Laminas\Filter\StaticFilter;

class PaymentForm
{
    public static function setFormValue(array $paymentConfig, array $data)
    {
        foreach ($paymentConfig as $key => $value) {
            $paymentConfig[$key] = is_array($value) ? self::getFormType($value, $data) : trim($value);
        }

        return $paymentConfig;
    }

    private static function getFormType(array $value, array $data)
    {
        switch ($value['inputType']) {
            case 'hidden':
            case 'text':
            case 'textarea':
            case 'image':
            case 'number':
                $value['content'] = StaticFilter::execute(trim($data[$value['nameId']]), 'htmlentities');
                break;
            case 'select':
                $value['selected'] = $data[$value['nameId']];
                break;
            case 'radio':
            case 'checkbox':
                $value['checked'] = isset($data[$value['nameId']]) ? $data[$value['nameId']] : [];
                break;
        }

        return $value;
    }

    public static function createFormInput(array $paymentConfig)
    {
        $inputArray = [];
        foreach ($paymentConfig as $value) {
            if(isset($value['inputType']) && !empty($value['inputType'])) {
                switch ($value['inputType']) {
                    case 'hidden':
                        $inputArray[] = self::getHiddenInput($value);
                        break;
                    case 'text':
                    case 'number':
                        $inputArray[] = self::getTextInput($value);
                        break;
                    case 'textarea':
                        $inputArray[] = self::getTextareaInput($value);
                        break;
                    case 'select':
                        $inputArray[] = self::getSelectInput($value);
                        break;
                    case 'radio':
                        $inputArray[] = self::getRadioInput($value);
                        break;
                    case 'checkbox':
                        $inputArray[] = self::getCheckBox($value);
                        break;
                    case 'image':
                        $inputArray[] = self::getImageInput($value);
                        break;
                }
            }
        }
        return $inputArray;
    }

    private static function getTextInput(array $data)
    {
        $array = [];
        $array['name']      = $data['title'];
        $array['input']     = '<input type="'.$data['inputType'].'" class="' . $data['class'] . '" name="' . $data['nameId'] . '" id="' . $data['nameId'] . '" value="' . $data['content'] . '" />';
        $array['type']      = $data['inputType'];
        $array['width']     = $data['width'];

        return $array;
    }

    private static function getSelectInput(array $data)
    {
        $array = [];
        $array['name'] = $data['title'];
        $array['input']= '<select class="' . $data['class'] . '" name="' . $data['nameId'] . '" id="' . $data['nameId'] . '">';
        foreach ($data['content'] as $value) {
            $array['input'] .= '<option value="' . $value['value'] . '" ' . ($data['selected'] == $value['value'] ? 'selected="selected"' : '') . '>' . $value['name'] . '</option>';
        }
        $array['input']     .= '</select>';
        $array['type']      = $data['inputType'];
        if(isset($data['width'])) $array['width']= $data['width'];

        return $array;
    }

    private static function getTextareaInput(array $data)
    {
        $array = [];
        $array['name']      = $data['title'];
        $array['input']     = '<textarea class="' . $data['class'] . '" name="' . $data['nameId'] . '" id="' . $data['nameId'] . '" rows="3">' . $data['content'] . '</textarea>';
        $array['type']      = $data['inputType'];
        if(isset($data['width'])) $array['width']= $data['width'];

        return $array;
    }

    private static function getRadioInput(array $data)
    {
        $array = [];
        $array['name']  = $data['title'];
        $array['input'] = '';
        foreach ($data['content'] as $value) {
            $array['input'] .= '<label class="radio-inline"><input type="radio" name="' . $data['nameId'] . '" ' . ($data['checked'] == $value['value'] ? 'checked="checked"' : '') . ' value="' . $value['value'] . '" />' . $value['name'] . '</label>';
        }
        $array['type'] = $data['inputType'];
        if(isset($data['width'])) $array['width']= $data['width'];

        return $array;
    }

    private static function getCheckBox(array $data)
    {
        $array = [];
        $array['name']  = $data['title'];
        $array['input'] = '';
        $data['checked']= !is_array($data['checked']) ? [$data['checked']] : $data['checked'];
        foreach ($data['content'] as $value) {
            $array['input'] .= '<label class="checkbox-inline"><input type="checkbox" ' .((isset($data['checked']) and is_array($data['checked']) and in_array($value['value'], $data['checked'])) ? 'checked' : ''). ' name="' . $data['nameId'] . '[]" value="' .$value['value']. '" />' .$value['name']. '</label>';
        }
        $array['type']      = $data['inputType'];
        if(isset($data['width'])) $array['width']= $data['width'];

        return $array;
    }

    private static function getHiddenInput(array $data)
    {
        $array = [];
        //$array['name']  = $data['title'];
        $array['input'] = $data['content'];
        $array['type']  = $data['inputType'];
        $array['hidden']= '<input type="hidden" name="' . $data['nameId'] . '" id="' . $data['nameId'] . '" value="' . $data['content'] . '" />';

        return $array;
    }

    private static function getImageInput (array $data)
    {
        $array = [];
        $array['name'] = $data['title'];
        $array['input']= $data['content'];
        $array['type'] = $data['inputType'];
        $array['hidden']= '<input type="hidden" name="' . $data['nameId'] . '" id="' . $data['nameId'] . '" value="' . $data['content'] . '" />';

        return $array;
    }
}