<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Service;

use Admin\Entity\PhoneAreaCode;
use Doctrine\ORM\EntityManager;

class PhoneAreaCodeManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加国际电话区号
     * @param array $data
     * @return PhoneAreaCode
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addPhoneArea(array $data)
    {
        $phoneArea = new PhoneAreaCode();
        $phoneArea->valuesSet($data);

        $this->entityManager->persist($phoneArea);
        $this->entityManager->flush();

        return $phoneArea;
    }

    /**
     * 编辑国际电话区号
     * @param array $data
     * @param PhoneAreaCode $phoneAreaCode
     * @return PhoneAreaCode
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editPhoneArea(array $data, PhoneAreaCode $phoneAreaCode)
    {
        if($phoneAreaCode->getAreaId() == 1) unset($data['areaState']);

        $phoneAreaCode->valuesSet($data);
        $this->entityManager->flush();

        return $phoneAreaCode;
    }

    /**
     * 删除国际电话区号
     * @param PhoneAreaCode $phoneAreaCode
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deletePhoneArea(PhoneAreaCode $phoneAreaCode)
    {
        $this->entityManager->remove($phoneAreaCode);
        $this->entityManager->flush();

        return true;
    }
}