<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Service;

use Admin\Entity\Plugin;
use Doctrine\ORM\EntityManager;

class PluginManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加插件
     * @param array $data
     * @return Plugin
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addPlugin(array $data)
    {
        $plugin = new Plugin();
        $plugin->valuesSet($data);

        $this->entityManager->persist($plugin);
        $this->entityManager->flush();

        return $plugin;
    }

    /**
     * 编辑插件
     * @param array $data
     * @param Plugin $plugin
     * @return Plugin
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editPlugin(array $data, Plugin $plugin)
    {
        $plugin->valuesSet($data);
        $this->entityManager->flush();

        return $plugin;
    }

    /**
     * 删除插件
     * @param Plugin $plugin
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deletePlugin(Plugin $plugin)
    {
        $this->entityManager->remove($plugin);
        $this->entityManager->flush();

        return true;
    }
}