<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Service;

use Admin\Entity\SelfLocation;
use Doctrine\ORM\EntityManager;

class SelfLocationManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;

    }

    /**
     * 添加自提点
     * @param array $data
     * @return SelfLocation
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addSelfLocation(array $data)
    {
        $location = new SelfLocation();
        $location->valuesSet($data);

        $this->entityManager->persist($location);
        $this->entityManager->flush();

        return $location;
    }

    /**
     * 编辑自提点
     * @param array $data
     * @param SelfLocation $selfLocation
     * @return SelfLocation
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editSelfLocation(array $data, SelfLocation $selfLocation)
    {
        $selfLocation->valuesSet($data);
        $this->entityManager->flush();

        return $selfLocation;
    }

    /**
     * 删除自提点
     * @param SelfLocation $selfLocation
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deleteSelfLocation(SelfLocation $selfLocation)
    {
        $this->entityManager->remove($selfLocation);
        $this->entityManager->flush();

        return true;
    }
}