<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\Service;

use Admin\Entity\System;
use Doctrine\ORM\EntityManager;

class SystemManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加
     * @param array $data
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addSystem(array $data)
    {
        $system = new System();
        $system->valuesSet($data);

        $this->entityManager->persist($system);
        $this->entityManager->flush();
    }

    /**
     * 更新
     * @param System $system
     * @param $sysBody
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editSystem(System $system, $sysBody)
    {
        $system->setSysBody($sysBody);
        $this->entityManager->flush();
    }
}