<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\View\Helper;

use Admin\Data\Common;
use Admin\Data\Config;
use Laminas\View\Helper\AbstractHelper;

class DateFormatHelper extends AbstractHelper
{

    public function __construct()
    {
    }

    /**
     * 后台右上角日期显示
     * @return mixed
     */
    public function adminShowDate()
    {
        return $this->getView()->dateFormat(time(), \IntlDateFormatter::MEDIUM, \IntlDateFormatter::NONE, Config::SHOP_DATE_FORMAT);
    }

    /**
     * 管理员列表时间显示
     * @param $dateTime
     * @return mixed
     */
    public function adminAddTime($dateTime)
    {
        return $this->getView()->dateFormat($dateTime, \IntlDateFormatter::MEDIUM, \IntlDateFormatter::NONE, Config::SHOP_DATE_FORMAT);
    }

    /**
     * 操作日志列表时间显示
     * @param $dateTime
     * @return mixed
     */
    public function adminLogTime($dateTime)
    {
        return $this->getView()->dateFormat($dateTime, \IntlDateFormatter::MEDIUM, \IntlDateFormatter::MEDIUM, Config::SHOP_DATE_FORMAT);
    }

    /**
     * 商品咨询时间显示
     * @param $dateTime
     * @return mixed
     */
    public function goodsConsultTime($dateTime)
    {
        return $this->getView()->dateFormat($dateTime, \IntlDateFormatter::MEDIUM, \IntlDateFormatter::SHORT, Config::SHOP_DATE_FORMAT);
    }

    /**
     * 商品评价时间显示
     * @param $dateTime
     * @return mixed
     */
    public function goodsEvaluationTime($dateTime)
    {
        return $this->getView()->dateFormat($dateTime, \IntlDateFormatter::MEDIUM, \IntlDateFormatter::SHORT, Config::SHOP_DATE_FORMAT);
    }

    /**
     * 客户列表时间显示
     * @param $dateTime
     * @return mixed
     */
    public function userAddTime($dateTime)
    {
        return $this->getView()->dateFormat($dateTime, \IntlDateFormatter::MEDIUM, \IntlDateFormatter::SHORT, Config::SHOP_DATE_FORMAT);
    }

    /**
     * 余额记录时间显示
     * @param $dateTime
     * @return mixed
     */
    public function balanceLogTime($dateTime)
    {
        return $this->getView()->dateFormat($dateTime, \IntlDateFormatter::MEDIUM, \IntlDateFormatter::MEDIUM, Config::SHOP_DATE_FORMAT);
    }

    /**
     * 积分记录时间显示
     * @param $dateTime
     * @return mixed
     */
    public function integralLogTime($dateTime)
    {
        return $this->getView()->dateFormat($dateTime, \IntlDateFormatter::MEDIUM, \IntlDateFormatter::MEDIUM, Config::SHOP_DATE_FORMAT);
    }

    /**
     * 文章列表时间显示
     * @param $dateTime
     * @return mixed
     */
    public function cmsAddTime($dateTime)
    {
        return $this->getView()->dateFormat($dateTime, \IntlDateFormatter::MEDIUM, \IntlDateFormatter::SHORT, Config::SHOP_DATE_FORMAT);
    }

    /**
     * 订单时间
     * @param $dateTime
     * @return mixed
     */
    public function orderTime($dateTime)
    {
        if(empty($dateTime)) return '';
        return $this->getView()->dateFormat($dateTime, \IntlDateFormatter::MEDIUM, \IntlDateFormatter::SHORT, Config::SHOP_DATE_FORMAT);
    }

    /**
     * 充值时间
     * @param $dateTime
     * @return mixed
     */
    public function rechargeTime($dateTime)
    {
        return $this->getView()->dateFormat($dateTime, \IntlDateFormatter::MEDIUM, \IntlDateFormatter::SHORT, Config::SHOP_DATE_FORMAT);
    }

    /**
     * 退换货时间
     * @param $dateTime
     * @return mixed
     */
    public function orderGoodsReturnTime($dateTime)
    {
        return $this->getView()->dateFormat($dateTime, \IntlDateFormatter::MEDIUM, \IntlDateFormatter::SHORT, Config::SHOP_DATE_FORMAT);
    }

    /**
     * 充值码规则时间显示
     * @param $dateTime
     * @return mixed
     */
    public function rechargeCodeRuleTime($dateTime)
    {
        return $this->getView()->dateFormat($dateTime, \IntlDateFormatter::MEDIUM, \IntlDateFormatter::SHORT, Config::SHOP_DATE_FORMAT);
    }

    /**
     * 充值码时间显示
     * @param $dateTime
     * @return mixed
     */
    public function rechargeCodeTime($dateTime)
    {
        return $this->getView()->dateFormat($dateTime, \IntlDateFormatter::MEDIUM, \IntlDateFormatter::MEDIUM, Config::SHOP_DATE_FORMAT);
    }

    /**
     * 后台优惠券时间
     * @param $dateTime
     * @return mixed
     */
    public function couponTime($dateTime)
    {
        return $this->getView()->dateFormat($dateTime, \IntlDateFormatter::MEDIUM, \IntlDateFormatter::MEDIUM, Config::SHOP_DATE_FORMAT);
    }

    /*==========================================下面是前台显示==========================================*/
    /**
     * 文章列表时间显示
     * @param $dateTime
     * @return mixed
     */
    public function shopCmsAddTime($dateTime)
    {
        return $this->getView()->dateFormat($dateTime, \IntlDateFormatter::MEDIUM, \IntlDateFormatter::SHORT, Common::configValue('base', 'config')['f_language'] ?? Config::SHOP_DATE_FORMAT);
    }

    /**
     * 订单添加时间
     * @param $dateTime
     * @return mixed
     */
    public function shopOrderAddTime($dateTime)
    {
        return $this->getView()->dateFormat($dateTime, \IntlDateFormatter::MEDIUM, \IntlDateFormatter::SHORT, Common::configValue('base', 'config')['f_language'] ?? Config::SHOP_DATE_FORMAT);
    }

    /**
     * 订单时间
     * @param $dateTime
     * @return mixed
     */
    public function shopOrderTime($dateTime)
    {
        return $this->getView()->dateFormat($dateTime, \IntlDateFormatter::MEDIUM, \IntlDateFormatter::SHORT, Common::configValue('base', 'config')['f_language'] ?? Config::SHOP_DATE_FORMAT);
    }

    /**
     * 订单状态记录，时间显示
     * @param $dateTime
     * @return mixed
     */
    public function shopOrderStatusTime($dateTime)
    {
        return $this->getView()->dateFormat($dateTime, \IntlDateFormatter::MEDIUM, \IntlDateFormatter::SHORT, Common::configValue('base', 'config')['f_language'] ?? Config::SHOP_DATE_FORMAT);
    }

    /**
     * 退换货时间
     * @param $dateTime
     * @return mixed
     */
    public function shopOrderGoodsReturnTime($dateTime)
    {
        return $this->getView()->dateFormat($dateTime, \IntlDateFormatter::MEDIUM, \IntlDateFormatter::SHORT, Common::configValue('base', 'config')['f_language'] ?? Config::SHOP_DATE_FORMAT);
    }

    /**
     * 积分历史，时间显示
     * @param $dateTime
     * @return mixed
     */
    public function shopUserIntegralTime($dateTime)
    {
        return $this->getView()->dateFormat($dateTime, \IntlDateFormatter::MEDIUM, \IntlDateFormatter::SHORT, Common::configValue('base', 'config')['f_language'] ?? Config::SHOP_DATE_FORMAT);
    }

    /**
     * 余额记录时间显示
     * @param $dateTime
     * @return mixed
     */
    public function shopBalanceLogTime($dateTime)
    {
        return $this->getView()->dateFormat($dateTime, \IntlDateFormatter::MEDIUM, \IntlDateFormatter::MEDIUM, Common::configValue('base', 'config')['f_language'] ?? Config::SHOP_DATE_FORMAT);
    }

    /**
     * 余额提现时间
     * @param $dateTime
     * @return mixed
     */
    public function shopWithdrawTime($dateTime)
    {
        return $this->getView()->dateFormat($dateTime, \IntlDateFormatter::MEDIUM, \IntlDateFormatter::SHORT, Common::configValue('base', 'config')['f_language'] ?? Config::SHOP_DATE_FORMAT);
    }
}