<?php
/**
 * DBERP 进销存系统
 *
 * ==========================================================================
 * @link      http://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   http://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin\View\Helper\Factory;

use Admin\View\Helper\AdminHelper;
use Interop\Container\ContainerInterface;
use Laminas\Mvc\I18n\Translator;
use Laminas\ServiceManager\Factory\FactoryInterface;

class AdminHelperFactory implements FactoryInterface
{
    public function __invoke(ContainerInterface $container, $requestedName, array $options = null)
    {
        $translator     = $container->get(Translator::class);
        $request        = $routeMatch = $container->get('Application')->getMvcEvent()->getRequest();
        $routeMatch     = $container->get('Application')->getMvcEvent()->getRouteMatch();

        return new AdminHelper($translator, $request, $routeMatch);
    }
}